package civvi.osgi.desktop.view.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXPanel;

import civvi.osgi.desktop.swingx.SwingUtil;

/**
 * A {@link ListCellRenderer} for displaying {@link Task}s.
 * <p/>
 * TODO Hook in JProgressBar?
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 3rd Dec 2007
 */
public class TaskCellRenderer extends JXPanel
implements ListCellRenderer
{
	private static final long serialVersionUID = -3941178117583144163L;
	/*
	 * An empty <code>Border</code>. This field might not be used. To change the
	 * <code>Border</code> used by this renderer override the 
	 * <code>getListCellRendererComponent</code> method and set the border
	 * of the returned component directly.
	 */
	private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
	private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
	protected static Border noFocusBorder = DEFAULT_NO_FOCUS_BORDER;

	private final JLabel titleLabel;
	private final JLabel descriptionLabel;
	private final JLabel statusLabel;
	
	/**
	 * Constructs a default renderer object for an item
	 * in a list.
	 */
	public TaskCellRenderer() {
		super();
		setOpaque(true);
		setBorder(getNoFocusBorder());
		setName("List.cellRenderer");
		
		final GroupLayout layout = new GroupLayout(this);
		setLayout(layout);
		
		this.titleLabel = new JLabel();
		this.descriptionLabel = new JLabel();
		this.statusLabel = new JLabel();
		
		layout.setHorizontalGroup(
				layout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
						.addGap(3, 3, 3)
						.addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING)
								.addComponent(titleLabel, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE, Short.MAX_VALUE)
								.addComponent(descriptionLabel, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE, Short.MAX_VALUE))
								.addGap(3, 3, 3))
		);
		layout.setVerticalGroup(
				layout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addGap(3, 3, 3)
						.addComponent(titleLabel)
						.addGap(3, 3, 3)
						.addComponent(descriptionLabel, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE, Short.MAX_VALUE)
						.addGap(3, 3, 3))
		);
	}

	/**
	 * 
	 * TODO
	 *
	 * @return
	 */
	private Border getNoFocusBorder() {
		Border border = UIManager.getBorder("List.cellNoFocusBorder");
		if (System.getSecurityManager() != null) {
			if (border != null) return border;
			return SAFE_NO_FOCUS_BORDER;
		} else {
			if (border != null &&
					(noFocusBorder == null ||
							noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
				return border;
			}
			return noFocusBorder;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Component getListCellRendererComponent(
			JList list,
			Object value,
			int index,
			boolean isSelected,
			boolean cellHasFocus)
	{
		setComponentOrientation(list.getComponentOrientation());

		Color bg = null;
		Color fg = null;

		JList.DropLocation dropLocation = list.getDropLocation();
		if (dropLocation != null
				&& !dropLocation.isInsert()
				&& dropLocation.getIndex() == index) {

			bg = UIManager.getColor("List.dropCellBackground");
			fg = UIManager.getColor("List.dropCellForeground");

			isSelected = true;
		}

		if (isSelected) {
			setBackground(bg == null ? list.getSelectionBackground() : bg);
			setForeground(fg == null ? list.getSelectionForeground() : fg);
		} else {
			setBackground(list.getBackground());
			setForeground(list.getForeground());
		}
		this.titleLabel.setBackground(getBackground());
		this.descriptionLabel.setBackground(getBackground());
		this.titleLabel.setForeground(getForeground());
		this.descriptionLabel.setForeground(SwingUtil.alpha(getForeground(), .5f));
		
		setEnabled(list.isEnabled());
		this.titleLabel.setEnabled(isEnabled());
		this.descriptionLabel.setEnabled(isEnabled());
		
		setFont(list.getFont());
		this.titleLabel.setFont(getFont().deriveFont(11.0f).deriveFont(Font.BOLD));
		this.descriptionLabel.setFont(getFont());
		
		decorate((Task<?,?>) value);
		
		Border border = null;
		if (cellHasFocus) {
			if (isSelected) {
				border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
			}
			if (border == null) {
				border = UIManager.getBorder("List.focusCellHighlightBorder");
			}
		} else {
			border = getNoFocusBorder();
		}
		setBorder(border);

		return this;
	}

	/**
	 * TODO
	 *
	 * @param task
	 */
	private void decorate(Task<?,?> task) {
		this.titleLabel.setText(task.getTitle());
		this.descriptionLabel.setText(task.getDescription());
		this.statusLabel.setText(task.isStarted() ? "Running..." : "Queued");
	}
}
