package civvi.osgi.desktop.view.welcome;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;

import javax.swing.JComponent;
import javax.swing.JTextArea;

import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.TextPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter.HorizontalAlignment;
import org.jdesktop.swingx.painter.AbstractLayoutPainter.VerticalAlignment;

import civvi.osgi.desktop.swingx.painter.RadialGradientPainter;
import civvi.osgi.desktop.view.AbstractEditorView;

import com.jhlabs.image.ShadowFilter;

/**
 * The first view the user will see.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 10th October 2007
 */
public class WelcomeView extends AbstractEditorView {
	private static final long serialVersionUID = -175163678702166617L;

	public static final RadialGradientPaint BACKGROUND = new RadialGradientPaint(
			new Point2D.Double(1.0, 1.0),
			1.0f,
			new float[] { 0.0f, 1.0f },
			new Color[] { new Color(0, 0, 0, 0), new Color(0, 0, 0, 128) });

	/**
	 * <p>
	 * Default constructor.
	 * </p>
	 */
	public WelcomeView() {
		super("default");
		setClosable(false);
		setContent(createContent());
	}

	/**
	 * @return the content component.
	 */
	private JComponent createContent() {
		final RadialGradientPainter rectanglePainter =
			new RadialGradientPainter(BACKGROUND);
		rectanglePainter.setRounded(true);
		rectanglePainter.setRoundHeight(10);
		rectanglePainter.setRoundWidth(10);

		final JXPanel content = new JXPanel(new BorderLayout());
		content.setOpaque(false);
		content.setBackgroundPainter(rectanglePainter);

		final JXPanel titlePanel = new JXPanel();

		final ShadowFilter shadowFilter = new ShadowFilter();
		shadowFilter.setAngle(-90.0f);
		shadowFilter.setDistance(3.0f);
		shadowFilter.setRadius(3.0f);
		shadowFilter.setOpacity(0.75f);

		final TextPainter titlePainter = new TextPainter();
		titlePainter.setFont(new Font("Tahoma", Font.PLAIN, 32));
		titlePainter.setText(this.support.getString("name"));
		titlePainter.setFillPaint(Color.WHITE);
		titlePainter.setVerticalAlignment(VerticalAlignment.TOP);
		titlePainter.setHorizontalAlignment(HorizontalAlignment.LEFT);
		titlePainter.setInsets(new Insets(5,10,10,10));
		titlePainter.setFilters(shadowFilter);

		titlePanel.setBackgroundPainter(new CompoundPainter<JXPanel>(
				titlePainter,
				new GlossPainter()));
		titlePanel.setOpaque(false);
		titlePanel.setPreferredSize(new Dimension(300, 50));
		content.add(titlePanel, BorderLayout.NORTH);

		// annoyingly JTextAreas hijack the minimum & preferred dimensions
		final Dimension minimumSize = new Dimension(350, 200);
		final JTextArea textArea = new JTextArea() {
			private static final long serialVersionUID = 1L;
			public Dimension getPreferredSize() {
				return minimumSize;
			};
			@Override
			public Dimension getMinimumSize() {
				return minimumSize;
			}
		};
		textArea.setMargin(new Insets(5, 5, 5, 5));
		textArea.setEditable(false);
		textArea.setFont(getFont());
		textArea.setWrapStyleWord(true);
		textArea.setLineWrap(true);
		textArea.setOpaque(false);
		textArea.setText(this.support.getString("body"));
		textArea.setForeground(Color.WHITE);
		content.add(textArea, BorderLayout.CENTER);
		return content;
	}
}
