package civvi.osgi.desktop.wizard.neweditor;

import java.util.HashMap;
import java.util.Map;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

import civvi.osgi.desktop.DesktopService;
import civvi.osgi.desktop.EditableService;
import civvi.osgi.desktop.editor.Editable;
import civvi.osgi.desktop.swingx.wizard.AbstractWizardModel;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 14 Apr 2009
 */
public class NewEditableModel extends AbstractWizardModel<Object> {
//	private final EditableStepPanelResolver resolver = new EditableStepPanelResolver();
	
	private final BundleContext bundleContext;

	public NewEditableModel(final BundleContext bundleContext) {
		this.bundleContext = bundleContext;
		
		try {
			// Query for any service references matching any language.
			ServiceReference[] references = this.bundleContext.getServiceReferences(
					DesktopService.class.getName(), null);

			final Map<Class<? extends Editable>, EditableService<?>> types =
				new HashMap<Class<? extends Editable>, EditableService<?>>();
			
			if (references != null) {
				for (ServiceReference ref : references) {
					final DesktopService<?> service = (DesktopService<?>) this.bundleContext.getService(ref);
					if (service instanceof EditableService<?>) {
						final EditableService<?> editableService = (EditableService<?>) service;
						types.put(editableService.getType(), editableService);						
					}
				}
			}
			putValue("list.editable", types);
			
		} catch (InvalidSyntaxException ise) {
			throw new RuntimeException(ise);
		}
	}
}
