package civvi.osgi.desktop.wizard.neweditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import civvi.osgi.desktop.EditableService;
import civvi.osgi.desktop.editor.Editable;
import civvi.osgi.desktop.swingx.wizard.DefaultController;
import civvi.osgi.desktop.swingx.wizard.StepPanel;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 14 Apr 2009
 */
public class NewEditablePanelController
extends DefaultController<NewEditableModel>
{
	public static final String INITIAL = "initial";
	private Map<Class<? extends Editable>, EditableService<?>> subControllerMap =
		new HashMap<Class<? extends Editable>, EditableService<?>>();
	private Map<Class<? extends Editable>, DefaultController<NewEditableModel>> subControllerCacheMap =
		new HashMap<Class<? extends Editable>, DefaultController<NewEditableModel>>();

	public NewEditablePanelController() {
		super(INITIAL);
		this.stepMap.put(INITIAL, StartStepPanel.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public StepPanel getPanel(Object stepId, NewEditableModel model) {
		if (super.getPanel(stepId, model) != null) {
			return super.getPanel(stepId, model);
		}
		
		return getSubController(model).getPanel(stepId, model);
	}
	
	/**
	 * {@inheritDoc}
	 */
//	@Override
//	public Class<? extends StepPanel> getClass(Object stepId, NewEditableModel model) {
//		if (super.getClass(stepId, model) != null) {
//			return super.getClass(stepId, model);
//		}
//		
//		return getSubResolver(model).getClass(stepId, model);
//	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int stepCount(NewEditableModel model) {
//		AbstractEditablePanelController subController = getSubController(model);
//		if (subController != null) {
//			return getSubController(model).stepCount(model) + super.stepCount(model);
//		}
		return super.stepCount(model);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int indexOfStep(Object stepId, NewEditableModel model) {
		final int index = super.indexOfStep(stepId, model); 
		if (index != -1) {
			return index;
		}

		return getSubController(model).indexOfStep(stepId, model) + super.stepCount(model);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isFinishable(Object stepId, NewEditableModel model) {
		if (INITIAL.equals(stepId)) {
			return false;
		}
//		if (super.indexOfStep(stepId, model) != -1) {
//			return false; // cannot end from this controller
//		}
		
		return !subControllerMap.isEmpty() && super.isFinishable(stepId, model);
	}

	/**
	 * 
	 * TODO
	 *
	 * @param model
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private DefaultController<NewEditableModel> getSubController(NewEditableModel model) {
		loadPanels(model);
		
		final Class<? extends Editable> selected = 
			(Class<? extends Editable>) model.getValue("selected.editable");

		if (selected == null) {
			return null;
		}

		DefaultController<NewEditableModel> subController =
			subControllerCacheMap.get(selected);

		if (subController != null) {
			return subController;
		}

		final Class<? extends DefaultController<NewEditableModel>> clazz =
			this.subControllerMap.get(selected).getStepPanelResolverType();

		try {
			subController = clazz.newInstance();
			subControllerCacheMap.put(selected, subController);
			return subController;
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}	
	}

	/**
	 * 
	 * TODO
	 *
	 * @param model
	 */
	@SuppressWarnings("unchecked")
	private void loadPanels(NewEditableModel model) {
		if (subControllerMap.isEmpty()) {
			final Map<Class<? extends Editable>, EditableService<?>> types =
				(Map<Class<? extends Editable>, EditableService<?>>)
				model.getValue("list.editable");
			subControllerMap.putAll(types);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object[] getStepIds(NewEditableModel model) {
		List<Object> steps = new ArrayList<Object>();
		
		if (getSubController(model) != null) {
			steps.addAll(Arrays.asList(getSubController(model).getStepIds(model)));
		}
		steps.addAll(0, Arrays.asList(super.getStepIds(model)));
		return steps.toArray();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void finish(NewEditableModel model) {
		getSubController(model).finish(model);
	}
}
