package civvi.osgi.desktop.wizard.neweditor;

import java.awt.BorderLayout;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXPanel;

import civvi.osgi.desktop.EditableService;
import civvi.osgi.desktop.editor.Editable;
import civvi.osgi.desktop.editor.EditableCellRenderer;
import civvi.osgi.desktop.swingx.GenericListModel;
import civvi.osgi.desktop.swingx.wizard.AbstractHeaderStepPanel;
import civvi.osgi.desktop.swingx.wizard.WizardModel;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 20 Mar 2009
 */
public class StartStepPanel extends AbstractHeaderStepPanel {
	private static final long serialVersionUID = 1809430839646446073L;

	private final Logger log = Logger.getLogger(getClass().getName());
	private final JXList list;
	private final GenericListModel<Class<? extends Editable>> model;
	private final JLabel descriptionLabel;
	
	private WizardModel<?> wizardModel;
	private boolean associating;
	
	/**
	 * 
	 * TODO
	 *
	 */
	public StartStepPanel() {
		super();
		final JXPanel panel = new JXPanel(new BorderLayout(5, 5));
		panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		panel.add(new JScrollPane(this.list = new JXList()), BorderLayout.CENTER);
		panel.add(this.descriptionLabel = new JLabel(), BorderLayout.SOUTH);
		setContent(panel);
		this.list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		this.list.setCellRenderer(new EditableCellRenderer());
		this.list.setModel(this.model = new GenericListModel<Class<? extends Editable>>());
		this.list.addListSelectionListener(new ListSelectionHandler());
		this.descriptionLabel.setText(
				this.support.getString("selected.none"));
	}
	
	/**
	 * 
	 * TODO
	 *
	 * @param e
	 */
	private void handle(ListSelectionEvent e) {
		if (e.getValueIsAdjusting() || this.wizardModel == null || associating) {
			return;
		}

		@SuppressWarnings("unchecked")
		final Class<? extends Editable> selected =
			(Class<? extends Editable>) this.list.getSelectedValue();
		
		this.wizardModel.putValue("selected.editable", selected);

		if (selected == null) {
			this.descriptionLabel.setText(
					this.support.getString("selected.none"));
			return;
		}
		
		try {
			final BeanInfo beanInfo = Introspector.getBeanInfo(selected);
			final String description = beanInfo.getBeanDescriptor().getShortDescription();
			this.descriptionLabel.setText(
					this.support.getString("selected", description));
		} catch (IntrospectionException ie) {
			this.descriptionLabel.setText(
					this.support.getString("error", selected.getClass()));
			if (this.log.isLoggable(Level.WARNING)) {
				this.log.log(Level.WARNING, ie.getMessage(), ie);
			}
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	@SuppressWarnings("unchecked")
	public void associate(WizardModel<?> model) {
		associating = true;
		this.wizardModel = model;
		
		final Map<Class<? extends Editable>, EditableService<?>> types =
			(Map<Class<? extends Editable>, EditableService<?>>) model.getValue(
					"list.editable");
		this.model.clear();
		this.model.addAll(types.keySet());
		
		if (types.keySet().toArray().length > 0) {
			this.list.setPrototypeCellValue(types.keySet().toArray()[0]);
		}
		this.list.setSelectedValue(model.getValue("selected.editable"), true);
		associating = false;
	}


	// --- Inner Classes ---

	/**
	 * 
	 * TODO
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 20 Mar 2009
	 */
	private class ListSelectionHandler implements ListSelectionListener {
		@Override
		public void valueChanged(ListSelectionEvent e) {
			handle(e);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean validates() {
		return wizardModel.getValue("selected.editable") != null;
	}
}
