package civvi.common;

import static civvi.common.GenericsUtil.getParamType;
import static junit.framework.Assert.assertEquals;

import java.math.BigDecimal;
import java.util.HashMap;

import org.junit.Test;

/**
 * Tests {@link GenericsUtil}.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [14 Nov 2010]
 */
public class GenericsUtilTest {
	/**
	 * Tests {@link GenericsUtil#getParamType(Class, int)} via
	 * {@code TestMap#class}.
	 */
	@Test
	public void findParametersViaStatic() {
		assertEquals(Double.class, getParamType(TestMap.class, 0));
		assertEquals(BigDecimal.class, getParamType(TestMap.class, 1));
	}


	// --- Inner Classes ----

	private static class TestMap extends HashMap<Double, BigDecimal> {
		private static final long serialVersionUID = 1L;
	}
}
