package civvi.osgi.desktop.tail;

import java.util.HashSet;
import java.util.Set;

import org.osgi.framework.BundleContext;

import civvi.osgi.desktop.AbstractEditableService;
import civvi.osgi.desktop.DesktopContext;
import civvi.osgi.desktop.editor.Editable;
import civvi.osgi.desktop.swingx.wizard.DefaultController;
import civvi.osgi.desktop.tail.view.TailView;
import civvi.osgi.desktop.tail.wizard.TailEditablePanelController;
import civvi.osgi.desktop.view.AbstractView;
import civvi.osgi.desktop.wizard.neweditor.NewEditableModel;

/**
 * A {@link EditableService} for tailing a file.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [14 Jun 2010]
 */
public class TailDesktopService
extends AbstractEditableService<DesktopContext>
{
	private final Set<Class<? extends AbstractView>> viewSet =
		new HashSet<Class<? extends AbstractView>>();

	public TailDesktopService(BundleContext context) {
		super(context);
		viewSet.add(TailView.class);
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public Class<? extends AbstractView>[] getViews() {
		return viewSet.toArray(new Class[viewSet.size()]);
	}
	
	@Override
	public Class<? extends DefaultController<NewEditableModel>>
	getStepPanelResolverType()
	{
		return TailEditablePanelController.class;
	}

	@Override
	public Class<? extends Editable> getType() {
		return TailEditable.class;
	}
}
