package civvi.osgi.desktop.tail.business;

import java.io.File;
import java.io.FileNotFoundException;

/**
 * Implements console-based log file tailing, or more specifically, tail following:
 * it is somewhat equivalent to the unix command "tail -f"
 * 
 * @author <a href="mailto:dan.siviter@civvi.com">Dan Siviter</a>
 * @since 19 Mar 2009
 */
public class ConsoleTail implements TailListener
{
	/**
	 * The log file tailer
	 */
	private FileTailer tailer;

	/**
	 * Creates a new Tail instance to follow the specified file
	 */
	public ConsoleTail(String filename) {
		tailer = new FileTailer();
		tailer.setFile(new File(filename));
		tailer.addListener(this);
	}

	@Override
	public void newLine(TailEvent e) {
		System.out.print(e.getText());
	}

	/**
	 * Command-line launcher
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args) throws FileNotFoundException {
		if (args.length < 1) {
			System.out.println("Usage: Tail <filename>");
			System.exit(0);
		}
		new ConsoleTail(args[0]).tailer.start();
	}
}
