package civvi.osgi.desktop.tail.internal;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

import civvi.osgi.desktop.DesktopService;
import civvi.osgi.desktop.tail.TailDesktopService;


/**
 * Activator for the Tail plugin functionality.
 * 
 * @author <a href="mailto:dan.siviter@civvi.com">Dan Siviter</a>
 * @since 24th July 2008
 */
public class Activator implements BundleActivator {
	private final Logger log = Logger.getLogger(getClass().getName());

	private BundleContext context;


	/**
	 * {@inheritDoc}
	 */
	@Override
	public void start(final BundleContext context)
	throws InterruptedException, InvalidSyntaxException
	{
		if (this.log.isLoggable(Level.INFO)) {
			this.log.info("Starting TailEditable plugin.");
		}

		synchronized (this) {
			this.context = context;

			final TailDesktopService desktopService = new TailDesktopService(context);
			// install services
			context.registerService(
					DesktopService.class.getName(),
					desktopService,
					new Properties());
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		if (this.log.isLoggable(Level.INFO)) {
			this.log.info("Stopping TailEditable plugin.");
		}
		synchronized (this) {
			this.context = null;
		}
	}

	/**
	 * @return the context.
	 */
	public BundleContext getContext() {
		return this.context;
	}
}
