package civvi.osgi.desktop.tail.wizard;

import java.io.File;

import org.jdesktop.application.Application;

import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.wizard.DefaultController;
import civvi.osgi.desktop.tail.TailEditable;
import civvi.osgi.desktop.tail.view.TailView;
import civvi.osgi.desktop.wizard.neweditor.NewEditableModel;

/**
 * Controls the new {@link TailEditable} wizard.
 * 
 * @author <a href="mailto:dan.siviter@civvi.com">Dan Siviter</a>
 * @since 14 Apr 2009
 */
public class TailEditablePanelController
extends DefaultController<NewEditableModel>
{
	private static final String SELECT_FILE = "select_file";
	
	public TailEditablePanelController() {
		super(SELECT_FILE);
		this.stepMap.put(SELECT_FILE, TailEditableStepPanel.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void finish(NewEditableModel model) {
		final File file = (File) model.getValue("selected.file");
		
		if (file == null) {
			throw new IllegalStateException("Selected file missing!");
		}
		
		final OSGiDesktop desktop = (OSGiDesktop) Application.getContext().getApplication();
		desktop.getViewManager().dock(new TailView(new TailEditable(file)), null);
	}
}
