/* This file was generated with JastAdd2 (http://jastadd.org) version R20130212 (r1031) */
package soot.JastAddJ;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

import soot.Scene;
import soot.SootField;
import soot.SootFieldRef;

/**
 * @production FieldDeclaration : {@link MemberDecl} ::=
 *             <span class="component">{@link Modifiers}</span>
 *             <span class="component">TypeAccess:{@link Access}</span>
 *             <span class="component">&lt;ID:String&gt;</span>
 *             <span class="component">[Init:{@link Expr}]</span>;
 * @ast node
 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/java.ast:80
 */
public class FieldDeclaration extends MemberDecl implements Cloneable, SimpleSet, Iterator, Variable {
	/**
	 * @apilevel low-level
	 */
	public void flushCache() {
		super.flushCache();
		accessibleFrom_TypeDecl_values = null;
		exceptions_computed = false;
		exceptions_value = null;
		isDAafter_Variable_values = null;
		isDUafter_Variable_values = null;
		constant_computed = false;
		constant_value = null;
		usesTypeVariable_computed = false;
		sourceVariableDecl_computed = false;
		sourceVariableDecl_value = null;
		sootRef_computed = false;
		sootRef_value = null;
		throwTypes_computed = false;
		throwTypes_value = null;
	}

	/**
	 * @apilevel internal
	 */
	public void flushCollectionCache() {
		super.flushCollectionCache();
	}

	/**
	 * @apilevel internal
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public FieldDeclaration clone() throws CloneNotSupportedException {
		FieldDeclaration node = (FieldDeclaration) super.clone();
		node.accessibleFrom_TypeDecl_values = null;
		node.exceptions_computed = false;
		node.exceptions_value = null;
		node.isDAafter_Variable_values = null;
		node.isDUafter_Variable_values = null;
		node.constant_computed = false;
		node.constant_value = null;
		node.usesTypeVariable_computed = false;
		node.sourceVariableDecl_computed = false;
		node.sourceVariableDecl_value = null;
		node.sootRef_computed = false;
		node.sootRef_value = null;
		node.throwTypes_computed = false;
		node.throwTypes_value = null;
		node.in$Circle(false);
		node.is$Final(false);
		return node;
	}

	/**
	 * @apilevel internal
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public FieldDeclaration copy() {
		try {
			FieldDeclaration node = (FieldDeclaration) clone();
			node.parent = null;
			if (children != null)
				node.children = (ASTNode[]) children.clone();
			return node;
		} catch (CloneNotSupportedException e) {
			throw new Error("Error: clone not supported for " + getClass().getName());
		}
	}

	/**
	 * Create a deep copy of the AST subtree at this node. The copy is dangling,
	 * i.e. has no parent.
	 * 
	 * @return dangling copy of the subtree at this node
	 * @apilevel low-level
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public FieldDeclaration fullCopy() {
		FieldDeclaration tree = (FieldDeclaration) copy();
		if (children != null) {
			for (int i = 0; i < children.length; ++i) {
				ASTNode child = (ASTNode) children[i];
				if (child != null) {
					child = child.fullCopy();
					tree.setChild(child, i);
				}
			}
		}
		return tree;
	}

	/**
	 * @ast method
	 * @aspect BoundNames
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/BoundNames.jrag:11
	 */
	public Access createQualifiedBoundAccess() {
		if (isStatic())
			return hostType().createQualifiedAccess().qualifiesAccess(new BoundFieldAccess(this));
		else
			return new ThisAccess("this").qualifiesAccess(new BoundFieldAccess(this));
	}

	/**
	 * @ast method
	 * @aspect BoundNames
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/BoundNames.jrag:86
	 */
	public Access createBoundFieldAccess() {
		return createQualifiedBoundAccess();
	}

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:81
	 */
	public SimpleSet add(Object o) {
		return new SimpleSetImpl().add(this).add(o);
	}

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:85
	 */
	public boolean isSingleton() {
		return true;
	}

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:86
	 */
	public boolean isSingleton(Object o) {
		return contains(o);
	}

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:89
	 */

	private FieldDeclaration iterElem;

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:90
	 */
	public Iterator iterator() {
		iterElem = this;
		return this;
	}

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:91
	 */
	public boolean hasNext() {
		return iterElem != null;
	}

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:92
	 */
	public Object next() {
		Object o = iterElem;
		iterElem = null;
		return o;
	}

	/**
	 * @ast method
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:93
	 */
	public void remove() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @ast method
	 * @aspect DefiniteAssignment
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DefiniteAssignment.jrag:177
	 */
	public void definiteAssignment() {
		super.definiteAssignment();
		if (isBlank() && isFinal() && isClassVariable()) {
			boolean found = false;
			TypeDecl typeDecl = hostType();
			for (int i = 0; i < typeDecl.getNumBodyDecl(); i++) {
				if (typeDecl.getBodyDecl(i) instanceof StaticInitializer) {
					StaticInitializer s = (StaticInitializer) typeDecl.getBodyDecl(i);
					if (s.isDAafter(this))
						found = true;
				}

				else if (typeDecl.getBodyDecl(i) instanceof FieldDeclaration) {
					FieldDeclaration f = (FieldDeclaration) typeDecl.getBodyDecl(i);
					if (f.isStatic() && f.isDAafter(this))
						found = true;
				}

			}
			if (!found)
				error("blank final class variable " + name() + " in " + hostType().typeName()
						+ " is not definitely assigned in static initializer");

		}
		if (isBlank() && isFinal() && isInstanceVariable()) {
			TypeDecl typeDecl = hostType();
			boolean found = false;
			for (int i = 0; !found && i < typeDecl.getNumBodyDecl(); i++) {
				if (typeDecl.getBodyDecl(i) instanceof FieldDeclaration) {
					FieldDeclaration f = (FieldDeclaration) typeDecl.getBodyDecl(i);
					if (!f.isStatic() && f.isDAafter(this))
						found = true;
				} else if (typeDecl.getBodyDecl(i) instanceof InstanceInitializer) {
					InstanceInitializer ii = (InstanceInitializer) typeDecl.getBodyDecl(i);
					if (ii.getBlock().isDAafter(this))
						found = true;
				}
			}
			for (Iterator iter = typeDecl.constructors().iterator(); !found && iter.hasNext();) {
				ConstructorDecl c = (ConstructorDecl) iter.next();
				if (!c.isDAafter(this)) {
					error("blank final instance variable " + name() + " in " + hostType().typeName()
							+ " is not definitely assigned after " + c.signature());
				}
			}
		}
		if (isBlank() && hostType().isInterfaceDecl()) {
			error("variable  " + name() + " in " + hostType().typeName()
					+ " which is an interface must have an initializer");
		}

	}

	/**
	 * @ast method
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:114
	 */
	public void checkModifiers() {
		super.checkModifiers();
		if (hostType().isInterfaceDecl()) {
			if (isProtected())
				error("an interface field may not be protected");
			if (isPrivate())
				error("an interface field may not be private");
			if (isTransient())
				error("an interface field may not be transient");
			if (isVolatile())
				error("an interface field may not be volatile");
		}
	}

	/**
	 * @ast method
	 * @aspect NameCheck
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/NameCheck.jrag:282
	 */
	public void nameCheck() {
		super.nameCheck();
		// 8.3
		for (Iterator iter = hostType().memberFields(name()).iterator(); iter.hasNext();) {
			Variable v = (Variable) iter.next();
			if (v != this && v.hostType() == hostType())
				error("field named " + name() + " is multiply declared in type " + hostType().typeName());
		}

	}

	/**
	 * @ast method
	 * @aspect NodeConstructors
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/NodeConstructors.jrag:86
	 */
	public FieldDeclaration(Modifiers m, Access type, String name) {
		this(m, type, name, new Opt());
	}

	/**
	 * @ast method
	 * @aspect NodeConstructors
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/NodeConstructors.jrag:90
	 */
	public FieldDeclaration(Modifiers m, Access type, String name, Expr init) {
		this(m, type, name, new Opt(init));
	}

	/**
	 * @ast method
	 * @aspect PrettyPrint
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/PrettyPrint.jadd:152
	 */
	public void toString(StringBuffer s) {
		s.append(indent());
		getModifiers().toString(s);
		getTypeAccess().toString(s);
		s.append(" " + name());
		if (hasInit()) {
			s.append(" = ");
			getInit().toString(s);
		}
		s.append(";");
	}

	/**
	 * @ast method
	 * @aspect TypeCheck
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/TypeCheck.jrag:33
	 */
	public void typeCheck() {
		if (hasInit()) {
			TypeDecl source = getInit().type();
			TypeDecl dest = type();
			if (!source.assignConversionTo(dest, getInit()))
				error("can not assign field " + name() + " of type " + dest.typeName() + " a value of type "
						+ source.typeName());
		}
	}

	/**
	 * @ast method
	 * @aspect VariableDeclarationTransformation
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:91
	 */

	// when splitting a FieldDecl into multiple FieldDeclarations, provide every
	// FieldDeclaration with a reference
	// to the original FieldDecl; if only a single FieldDeclaration results, no
	// reference is stored
	private FieldDecl fieldDecl = null;

	/**
	 * @ast method
	 * @aspect VariableDeclarationTransformation
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:92
	 */
	public FieldDecl getFieldDecl() {
		return fieldDecl;
	}

	/**
	 * @ast method
	 * @aspect VariableDeclarationTransformation
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:95
	 */
	public void setFieldDecl(FieldDecl fieldDecl) {
		this.fieldDecl = fieldDecl;
	}

	/**
	 * @ast method
	 * @aspect LookupParTypeDecl
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/Generics.jrag:1295
	 */
	public BodyDecl substitutedBodyDecl(Parameterization parTypeDecl) {
		FieldDeclaration f = new FieldDeclarationSubstituted((Modifiers) getModifiers().fullCopy(),
				getTypeAccess().type().substituteReturnType(parTypeDecl), getID(), new Opt(), this);
		return f;
	}

	/**
	 * @ast method
	 * @aspect InnerClasses
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Backend/InnerClasses.jrag:290
	 */
	public MethodDecl createAccessor(TypeDecl fieldQualifier) {
		MethodDecl m = (MethodDecl) fieldQualifier.getAccessor(this, "field_read");
		if (m != null)
			return m;

		int accessorIndex = fieldQualifier.accessorCounter++;
		Modifiers modifiers = new Modifiers(new List());
		modifiers.addModifier(new Modifier("static"));
		modifiers.addModifier(new Modifier("synthetic"));
		modifiers.addModifier(new Modifier("public"));

		List parameters = new List();
		if (!isStatic())
			parameters.add(new ParameterDeclaration(fieldQualifier.createQualifiedAccess(), "that"));

		m = new MethodDecl(modifiers, type().createQualifiedAccess(), "get$" + name() + "$access$" + accessorIndex,
				parameters, new List(), new Opt(new Block(new List().add(new ReturnStmt(createAccess())))));
		m = fieldQualifier.addMemberMethod(m);
		fieldQualifier.addAccessor(this, "field_read", m);
		return m;
	}

	/**
	 * @ast method
	 * @aspect InnerClasses
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Backend/InnerClasses.jrag:323
	 */
	public MethodDecl createAccessorWrite(TypeDecl fieldQualifier) {
		MethodDecl m = (MethodDecl) fieldQualifier.getAccessor(this, "field_write");
		if (m != null)
			return m;

		int accessorIndex = fieldQualifier.accessorCounter++;
		Modifiers modifiers = new Modifiers(new List());
		modifiers.addModifier(new Modifier("static"));
		modifiers.addModifier(new Modifier("synthetic"));
		modifiers.addModifier(new Modifier("public"));

		List parameters = new List();
		if (!isStatic())
			parameters.add(new ParameterDeclaration(fieldQualifier.createQualifiedAccess(), "that"));
		parameters.add(new ParameterDeclaration(type().createQualifiedAccess(), "value"));

		m = new MethodDecl(modifiers, type().createQualifiedAccess(), "set$" + name() + "$access$" + accessorIndex,
				parameters, new List(),
				new Opt(new Block(
						new List().add(new ExprStmt(new AssignSimpleExpr(createAccess(), new VarAccess("value"))))
								.add(new ReturnStmt(new Opt(new VarAccess("value")))))));
		m = fieldQualifier.addMemberMethod(m);
		fieldQualifier.addAccessor(this, "field_write", m);
		return m;
	}

	/**
	 * @ast method
	 * @aspect InnerClasses
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Backend/InnerClasses.jrag:368
	 */
	private Access createAccess() {
		Access fieldAccess = new BoundFieldAccess(this);
		return isStatic() ? fieldAccess : new VarAccess("that").qualifiesAccess(fieldAccess);
	}

	/**
	 * @ast method
	 * @aspect EmitJimple
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddExtensions/JimpleBackend/EmitJimple.jrag:329
	 */
	public void jimplify1phase2() {
		String name = name();
		soot.Type type = type().getSootType();
		int modifiers = sootTypeModifiers();
		if (!hostType().getSootClassDecl().declaresFieldByName(name)) {
			SootField f = Scene.v().makeSootField(name, type, modifiers);
			hostType().getSootClassDecl().addField(f);
			if (isStatic() && isFinal() && isConstant() && (type().isPrimitive() || type().isString())) {
				if (type().isString())
					f.addTag(new soot.tagkit.StringConstantValueTag(constant().stringValue()));
				else if (type().isLong())
					f.addTag(new soot.tagkit.LongConstantValueTag(constant().longValue()));
				else if (type().isDouble())
					f.addTag(new soot.tagkit.DoubleConstantValueTag(constant().doubleValue()));
				else if (type().isFloat())
					f.addTag(new soot.tagkit.FloatConstantValueTag(constant().floatValue()));
				else if (type().isIntegralType())
					f.addTag(new soot.tagkit.IntegerConstantValueTag(constant().intValue()));
			}
			sootField = f;
		} else {
			sootField = hostType().getSootClassDecl().getFieldByName(name);
		}
		addAttributes();
	}

	/**
	 * @ast method
	 * @aspect EmitJimple
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddExtensions/JimpleBackend/EmitJimple.jrag:354
	 */

	public SootField sootField;

	/**
	 * @ast method
	 * @aspect AnnotationsCodegen
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddExtensions/Jimple1.5Backend/AnnotationsCodegen.jrag:32
	 */
	public void addAttributes() {
		super.addAttributes();
		ArrayList c = new ArrayList();
		getModifiers().addRuntimeVisibleAnnotationsAttribute(c);
		getModifiers().addRuntimeInvisibleAnnotationsAttribute(c);
		getModifiers().addSourceOnlyAnnotations(c);
		for (Iterator iter = c.iterator(); iter.hasNext();) {
			soot.tagkit.Tag tag = (soot.tagkit.Tag) iter.next();
			sootField.addTag(tag);
		}
	}

	/**
	 * @ast method
	 * @aspect UncheckedConversion
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java7Frontend/UncheckedConversion.jrag:25
	 */
	public void checkWarnings() {
		if (hasInit() && !suppressWarnings("unchecked"))
			checkUncheckedConversion(getInit().type(), type());
	}

	/**
	 * @ast method
	 * 
	 */
	public FieldDeclaration() {
		super();

	}

	/**
	 * Initializes the child array to the correct size. Initializes List and Opt
	 * nta children.
	 * 
	 * @apilevel internal
	 * @ast method
	 * @ast method
	 * 
	 */
	public void init$Children() {
		children = new ASTNode[3];
		setChild(new Opt(), 2);
	}

	/**
	 * @ast method
	 * 
	 */
	public FieldDeclaration(Modifiers p0, Access p1, String p2, Opt<Expr> p3) {
		setChild(p0, 0);
		setChild(p1, 1);
		setID(p2);
		setChild(p3, 2);
	}

	/**
	 * @ast method
	 * 
	 */
	public FieldDeclaration(Modifiers p0, Access p1, beaver.Symbol p2, Opt<Expr> p3) {
		setChild(p0, 0);
		setChild(p1, 1);
		setID(p2);
		setChild(p3, 2);
	}

	/**
	 * @apilevel low-level
	 * @ast method
	 * 
	 */
	protected int numChildren() {
		return 3;
	}

	/**
	 * @apilevel internal
	 * @ast method
	 * 
	 */
	public boolean mayHaveRewrite() {
		return false;
	}

	/**
	 * Replaces the Modifiers child.
	 * 
	 * @param node
	 *            The new node to replace the Modifiers child.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public void setModifiers(Modifiers node) {
		setChild(node, 0);
	}

	/**
	 * Retrieves the Modifiers child.
	 * 
	 * @return The current node used as the Modifiers child.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public Modifiers getModifiers() {
		return (Modifiers) getChild(0);
	}

	/**
	 * Retrieves the Modifiers child.
	 * <p>
	 * <em>This method does not invoke AST transformations.</em>
	 * </p>
	 * 
	 * @return The current node used as the Modifiers child.
	 * @apilevel low-level
	 * @ast method
	 * 
	 */
	public Modifiers getModifiersNoTransform() {
		return (Modifiers) getChildNoTransform(0);
	}

	/**
	 * Replaces the TypeAccess child.
	 * 
	 * @param node
	 *            The new node to replace the TypeAccess child.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public void setTypeAccess(Access node) {
		setChild(node, 1);
	}

	/**
	 * Retrieves the TypeAccess child.
	 * 
	 * @return The current node used as the TypeAccess child.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public Access getTypeAccess() {
		return (Access) getChild(1);
	}

	/**
	 * Retrieves the TypeAccess child.
	 * <p>
	 * <em>This method does not invoke AST transformations.</em>
	 * </p>
	 * 
	 * @return The current node used as the TypeAccess child.
	 * @apilevel low-level
	 * @ast method
	 * 
	 */
	public Access getTypeAccessNoTransform() {
		return (Access) getChildNoTransform(1);
	}

	/**
	 * Replaces the lexeme ID.
	 * 
	 * @param value
	 *            The new value for the lexeme ID.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public void setID(String value) {
		tokenString_ID = value;
	}

	/**
	 * @apilevel internal
	 * @ast method
	 * 
	 */

	/**
	 * @apilevel internal
	 */
	protected String tokenString_ID;
	/**
	 * @ast method
	 * 
	 */

	public int IDstart;
	/**
	 * @ast method
	 * 
	 */

	public int IDend;

	/**
	 * JastAdd-internal setter for lexeme ID using the Beaver parser.
	 * 
	 * @apilevel internal
	 * @ast method
	 * 
	 */
	public void setID(beaver.Symbol symbol) {
		if (symbol.value != null && !(symbol.value instanceof String))
			throw new UnsupportedOperationException("setID is only valid for String lexemes");
		tokenString_ID = (String) symbol.value;
		IDstart = symbol.getStart();
		IDend = symbol.getEnd();
	}

	/**
	 * Retrieves the value for the lexeme ID.
	 * 
	 * @return The value for the lexeme ID.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public String getID() {
		return tokenString_ID != null ? tokenString_ID : "";
	}

	/**
	 * Replaces the optional node for the Init child. This is the {@code Opt}
	 * node containing the child Init, not the actual child!
	 * 
	 * @param opt
	 *            The new node to be used as the optional node for the Init
	 *            child.
	 * @apilevel low-level
	 * @ast method
	 * 
	 */
	public void setInitOpt(Opt<Expr> opt) {
		setChild(opt, 2);
	}

	/**
	 * Check whether the optional Init child exists.
	 * 
	 * @return {@code true} if the optional Init child exists, {@code false} if
	 *         it does not.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public boolean hasInit() {
		return getInitOpt().getNumChild() != 0;
	}

	/**
	 * Retrieves the (optional) Init child.
	 * 
	 * @return The Init child, if it exists. Returns {@code null} otherwise.
	 * @apilevel low-level
	 * @ast method
	 * 
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public Expr getInit() {
		return (Expr) getInitOpt().getChild(0);
	}

	/**
	 * Replaces the (optional) Init child.
	 * 
	 * @param node
	 *            The new node to be used as the Init child.
	 * @apilevel high-level
	 * @ast method
	 * 
	 */
	public void setInit(Expr node) {
		getInitOpt().setChild(node, 0);
	}

	/**
	 * @apilevel low-level
	 * @ast method
	 * 
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public Opt<Expr> getInitOpt() {
		return (Opt<Expr>) getChild(2);
	}

	/**
	 * Retrieves the optional node for child Init. This is the {@code Opt} node
	 * containing the child Init, not the actual child!
	 * <p>
	 * <em>This method does not invoke AST transformations.</em>
	 * </p>
	 * 
	 * @return The optional node for child Init.
	 * @apilevel low-level
	 * @ast method
	 * 
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public Opt<Expr> getInitOptNoTransform() {
		return (Opt<Expr>) getChildNoTransform(2);
	}

	/**
	 * @attribute syn
	 * @aspect ConstantExpression
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java7Frontend/ConstantExpression.jrag:332
	 */
	public boolean isConstant() {
		ASTNode$State state = state();
		try {
			return isFinal() && hasInit() && getInit().isConstant()
					&& (type() instanceof PrimitiveType || type().isString());
		} finally {
		}
	}

	protected java.util.Map accessibleFrom_TypeDecl_values;

	/**
	 * @attribute syn
	 * @aspect AccessControl
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/AccessControl.jrag:109
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public boolean accessibleFrom(TypeDecl type) {
		Object _parameters = type;
		if (accessibleFrom_TypeDecl_values == null)
			accessibleFrom_TypeDecl_values = new java.util.HashMap(4);
		if (accessibleFrom_TypeDecl_values.containsKey(_parameters)) {
			return ((Boolean) accessibleFrom_TypeDecl_values.get(_parameters)).booleanValue();
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		boolean accessibleFrom_TypeDecl_value = accessibleFrom_compute(type);
		if (isFinal && num == state().boundariesCrossed)
			accessibleFrom_TypeDecl_values.put(_parameters, Boolean.valueOf(accessibleFrom_TypeDecl_value));
		return accessibleFrom_TypeDecl_value;
	}

	/**
	 * @apilevel internal
	 */
	private boolean accessibleFrom_compute(TypeDecl type) {
		if (isPublic())
			return true;
		else if (isProtected()) {
			if (hostPackage().equals(type.hostPackage()))
				return true;
			if (type.withinBodyThatSubclasses(hostType()) != null)
				return true;
			return false;
		} else if (isPrivate())
			return hostType().topLevelType() == type.topLevelType();
		else
			return hostPackage().equals(type.hostPackage());
	}

	/**
	 * @apilevel internal
	 */
	protected boolean exceptions_computed = false;
	/**
	 * @apilevel internal
	 */
	protected Collection exceptions_value;

	/**
	 * @attribute syn
	 * @aspect AnonymousClasses
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/AnonymousClasses.jrag:178
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public Collection exceptions() {
		if (exceptions_computed) {
			return exceptions_value;
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		exceptions_value = exceptions_compute();
		if (isFinal && num == state().boundariesCrossed)
			exceptions_computed = true;
		return exceptions_value;
	}

	/**
	 * @apilevel internal
	 */
	private Collection exceptions_compute() {
		HashSet set = new HashSet();
		if (isInstanceVariable() && hasInit()) {
			collectExceptions(set, this);
			for (Iterator iter = set.iterator(); iter.hasNext();) {
				TypeDecl typeDecl = (TypeDecl) iter.next();
				if (!getInit().reachedException(typeDecl))
					iter.remove();
			}
		}
		return set;
	}

	/**
	 * @attribute syn
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:79
	 */
	public int size() {
		ASTNode$State state = state();
		try {
			return 1;
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:80
	 */
	public boolean isEmpty() {
		ASTNode$State state = state();
		try {
			return false;
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect DataStructures
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DataStructures.jrag:84
	 */
	public boolean contains(Object o) {
		ASTNode$State state = state();
		try {
			return this == o;
		} finally {
		}
	}

	protected java.util.Map isDAafter_Variable_values;

	/**
	 * @attribute syn
	 * @aspect DA
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DefiniteAssignment.jrag:314
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public boolean isDAafter(Variable v) {
		Object _parameters = v;
		if (isDAafter_Variable_values == null)
			isDAafter_Variable_values = new java.util.HashMap(4);
		if (isDAafter_Variable_values.containsKey(_parameters)) {
			return ((Boolean) isDAafter_Variable_values.get(_parameters)).booleanValue();
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		boolean isDAafter_Variable_value = isDAafter_compute(v);
		if (isFinal && num == state().boundariesCrossed)
			isDAafter_Variable_values.put(_parameters, Boolean.valueOf(isDAafter_Variable_value));
		return isDAafter_Variable_value;
	}

	/**
	 * @apilevel internal
	 */
	private boolean isDAafter_compute(Variable v) {
		if (v == this)
			return hasInit();
		return hasInit() ? getInit().isDAafter(v) : isDAbefore(v);
	}

	protected java.util.Map isDUafter_Variable_values;

	/**
	 * @attribute syn
	 * @aspect DU
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DefiniteAssignment.jrag:771
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public boolean isDUafter(Variable v) {
		Object _parameters = v;
		if (isDUafter_Variable_values == null)
			isDUafter_Variable_values = new java.util.HashMap(4);
		if (isDUafter_Variable_values.containsKey(_parameters)) {
			return ((Boolean) isDUafter_Variable_values.get(_parameters)).booleanValue();
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		boolean isDUafter_Variable_value = isDUafter_compute(v);
		if (isFinal && num == state().boundariesCrossed)
			isDUafter_Variable_values.put(_parameters, Boolean.valueOf(isDUafter_Variable_value));
		return isDUafter_Variable_value;
	}

	/**
	 * @apilevel internal
	 */
	private boolean isDUafter_compute(Variable v) {
		if (v == this)
			return !hasInit();
		return hasInit() ? getInit().isDUafter(v) : isDUbefore(v);
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:214
	 */
	public boolean isSynthetic() {
		ASTNode$State state = state();
		try {
			return getModifiers().isSynthetic();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:239
	 */
	public boolean isPublic() {
		ASTNode$State state = state();
		try {
			return getModifiers().isPublic() || hostType().isInterfaceDecl();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:240
	 */
	public boolean isPrivate() {
		ASTNode$State state = state();
		try {
			return getModifiers().isPrivate();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:241
	 */
	public boolean isProtected() {
		ASTNode$State state = state();
		try {
			return getModifiers().isProtected();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:242
	 */
	public boolean isStatic() {
		ASTNode$State state = state();
		try {
			return getModifiers().isStatic() || hostType().isInterfaceDecl();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:244
	 */
	public boolean isFinal() {
		ASTNode$State state = state();
		try {
			return getModifiers().isFinal() || hostType().isInterfaceDecl();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:245
	 */
	public boolean isTransient() {
		ASTNode$State state = state();
		try {
			return getModifiers().isTransient();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Modifiers
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:246
	 */
	public boolean isVolatile() {
		ASTNode$State state = state();
		try {
			return getModifiers().isVolatile();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect PrettyPrint
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/PrettyPrint.jadd:800
	 */
	public String dumpString() {
		ASTNode$State state = state();
		try {
			return getClass().getName() + " [" + getID() + "]";
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect TypeAnalysis
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/TypeAnalysis.jrag:251
	 */
	public TypeDecl type() {
		ASTNode$State state = state();
		try {
			return getTypeAccess().type();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect TypeAnalysis
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/TypeAnalysis.jrag:271
	 */
	public boolean isVoid() {
		ASTNode$State state = state();
		try {
			return type().isVoid();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:32
	 */
	public boolean isParameter() {
		ASTNode$State state = state();
		try {
			return false;
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:34
	 */
	public boolean isClassVariable() {
		ASTNode$State state = state();
		try {
			return isStatic() || hostType().isInterfaceDecl();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:35
	 */
	public boolean isInstanceVariable() {
		ASTNode$State state = state();
		try {
			return (hostType().isClassDecl() || hostType().isAnonymous()) && !isStatic();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:36
	 */
	public boolean isMethodParameter() {
		ASTNode$State state = state();
		try {
			return false;
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:37
	 */
	public boolean isConstructorParameter() {
		ASTNode$State state = state();
		try {
			return false;
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:38
	 */
	public boolean isExceptionHandlerParameter() {
		ASTNode$State state = state();
		try {
			return false;
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:39
	 */
	public boolean isLocalVariable() {
		ASTNode$State state = state();
		try {
			return false;
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:41
	 */
	public boolean isBlank() {
		ASTNode$State state = state();
		try {
			return !hasInit();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:43
	 */
	public String name() {
		ASTNode$State state = state();
		try {
			return getID();
		} finally {
		}
	}

	/**
	 * @apilevel internal
	 */
	protected boolean constant_computed = false;
	/**
	 * @apilevel internal
	 */
	protected Constant constant_value;

	/**
	 * @attribute syn
	 * @aspect Variables
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/VariableDeclaration.jrag:44
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public Constant constant() {
		if (constant_computed) {
			return constant_value;
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		constant_value = constant_compute();
		if (isFinal && num == state().boundariesCrossed)
			constant_computed = true;
		return constant_value;
	}

	/**
	 * @apilevel internal
	 */
	private Constant constant_compute() {
		return type().cast(getInit().constant());
	}

	/**
	 * @attribute syn
	 * @aspect Annotations
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/Annotations.jrag:283
	 */
	public boolean hasAnnotationSuppressWarnings(String s) {
		ASTNode$State state = state();
		try {
			return getModifiers().hasAnnotationSuppressWarnings(s);
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect Annotations
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/Annotations.jrag:325
	 */
	public boolean isDeprecated() {
		ASTNode$State state = state();
		try {
			return getModifiers().hasDeprecatedAnnotation();
		} finally {
		}
	}

	/**
	 * @apilevel internal
	 */
	protected boolean usesTypeVariable_computed = false;
	/**
	 * @apilevel internal
	 */
	protected boolean usesTypeVariable_value;

	/**
	 * @attribute syn
	 * @aspect LookupParTypeDecl
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/Generics.jrag:1065
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public boolean usesTypeVariable() {
		if (usesTypeVariable_computed) {
			return usesTypeVariable_value;
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		usesTypeVariable_value = usesTypeVariable_compute();
		if (isFinal && num == state().boundariesCrossed)
			usesTypeVariable_computed = true;
		return usesTypeVariable_value;
	}

	/**
	 * @apilevel internal
	 */
	private boolean usesTypeVariable_compute() {
		return getTypeAccess().usesTypeVariable();
	}

	/**
	 * @apilevel internal
	 */
	protected boolean sourceVariableDecl_computed = false;
	/**
	 * @apilevel internal
	 */
	protected Variable sourceVariableDecl_value;

	/**
	 * @attribute syn
	 * @aspect SourceDeclarations
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/Generics.jrag:1521
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public Variable sourceVariableDecl() {
		if (sourceVariableDecl_computed) {
			return sourceVariableDecl_value;
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		sourceVariableDecl_value = sourceVariableDecl_compute();
		if (isFinal && num == state().boundariesCrossed)
			sourceVariableDecl_computed = true;
		return sourceVariableDecl_value;
	}

	/**
	 * @apilevel internal
	 */
	private Variable sourceVariableDecl_compute() {
		return this;
	}

	/**
	 * @attribute syn
	 * @aspect GenericsParTypeDecl
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/GenericsParTypeDecl.jrag:67
	 */
	public boolean visibleTypeParameters() {
		ASTNode$State state = state();
		try {
			return !isStatic();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect EmitJimple
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddExtensions/JimpleBackend/EmitJimple.jrag:127
	 */
	public int sootTypeModifiers() {
		ASTNode$State state = state();
		try {
			int result = 0;
			if (isPublic())
				result |= soot.Modifier.PUBLIC;
			if (isProtected())
				result |= soot.Modifier.PROTECTED;
			if (isPrivate())
				result |= soot.Modifier.PRIVATE;
			if (isFinal())
				result |= soot.Modifier.FINAL;
			if (isStatic())
				result |= soot.Modifier.STATIC;
			return result;
		} finally {
		}
	}

	/**
	 * @apilevel internal
	 */
	protected boolean sootRef_computed = false;
	/**
	 * @apilevel internal
	 */
	protected SootFieldRef sootRef_value;

	/**
	 * @attribute syn
	 * @aspect EmitJimple
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddExtensions/JimpleBackend/EmitJimple.jrag:355
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public SootFieldRef sootRef() {
		if (sootRef_computed) {
			return sootRef_value;
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		sootRef_value = sootRef_compute();
		if (isFinal && num == state().boundariesCrossed)
			sootRef_computed = true;
		return sootRef_value;
	}

	/**
	 * @apilevel internal
	 */
	private SootFieldRef sootRef_compute() {
		return Scene.v().makeFieldRef(hostType().getSootClassDecl(), name(), type().getSootType(), isStatic());
	}

	/**
	 * @attribute syn
	 * @aspect GenericsCodegen
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddExtensions/Jimple1.5Backend/GenericsCodegen.jrag:31
	 */
	public FieldDeclaration erasedField() {
		ASTNode$State state = state();
		try {
			return this;
		} finally {
		}
	}

	/**
	 * @apilevel internal
	 */
	protected boolean throwTypes_computed = false;
	/**
	 * @apilevel internal
	 */
	protected Collection<TypeDecl> throwTypes_value;

	/**
	 * @attribute syn
	 * @aspect PreciseRethrow
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java7Frontend/PreciseRethrow.jrag:22
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public Collection<TypeDecl> throwTypes() {
		if (throwTypes_computed) {
			return throwTypes_value;
		}
		ASTNode$State state = state();
		int num = state.boundariesCrossed;
		boolean isFinal = this.is$Final();
		throwTypes_value = throwTypes_compute();
		if (isFinal && num == state().boundariesCrossed)
			throwTypes_computed = true;
		return throwTypes_value;
	}

	/**
	 * @apilevel internal
	 */
	private Collection<TypeDecl> throwTypes_compute() {
		Collection<TypeDecl> tts = new LinkedList<TypeDecl>();
		tts.add(type());
		return tts;
	}

	/**
	 * @return true if the modifier list includes the SafeVarargs annotation
	 * @attribute syn
	 * @aspect SafeVarargs
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java7Frontend/SafeVarargs.jrag:20
	 */
	public boolean hasAnnotationSafeVarargs() {
		ASTNode$State state = state();
		try {
			return getModifiers().hasAnnotationSafeVarargs();
		} finally {
		}
	}

	/**
	 * @attribute syn
	 * @aspect SuppressWarnings
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java7Frontend/SuppressWarnings.jrag:22
	 */
	public boolean suppressWarnings(String type) {
		ASTNode$State state = state();
		try {
			return hasAnnotationSuppressWarnings(type) || withinSuppressWarnings(type);
		} finally {
		}
	}

	/**
	 * @attribute inh
	 * @aspect ExceptionHandling
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/ExceptionHandling.jrag:48
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public boolean handlesException(TypeDecl exceptionType) {
		ASTNode$State state = state();
		boolean handlesException_TypeDecl_value = getParent().Define_boolean_handlesException(this, null,
				exceptionType);
		return handlesException_TypeDecl_value;
	}

	/**
	 * @attribute inh
	 * @aspect SuppressWarnings
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java7Frontend/SuppressWarnings.jrag:14
	 */
	@SuppressWarnings({ "unchecked", "cast" })
	public boolean withinSuppressWarnings(String s) {
		ASTNode$State state = state();
		boolean withinSuppressWarnings_String_value = getParent().Define_boolean_withinSuppressWarnings(this, null, s);
		return withinSuppressWarnings_String_value;
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DefiniteAssignment.jrag:39
	 * @apilevel internal
	 */
	public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
		if (caller == getInitOptNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_isSource(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/DefiniteAssignment.jrag:320
	 * @apilevel internal
	 */
	public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
		if (caller == getInitOptNoTransform()) {
			return isDAbefore(v);
		} else {
			return getParent().Define_boolean_isDAbefore(this, caller, v);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/ExceptionHandling.jrag:166
	 * @apilevel internal
	 */
	public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
		if (caller == getInitOptNoTransform()) {
			if (hostType().isAnonymous())
				return true;
			if (!exceptionType.isUncheckedException())
				return true;
			for (Iterator iter = hostType().constructors().iterator(); iter.hasNext();) {
				ConstructorDecl decl = (ConstructorDecl) iter.next();
				if (!decl.throwsException(exceptionType))
					return false;
			}
			return true;
		} else {
			return getParent().Define_boolean_handlesException(this, caller, exceptionType);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:262
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
		if (caller == getModifiersNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_mayBePublic(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:263
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
		if (caller == getModifiersNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_mayBeProtected(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:264
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
		if (caller == getModifiersNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_mayBePrivate(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:265
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayBeStatic(ASTNode caller, ASTNode child) {
		if (caller == getModifiersNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_mayBeStatic(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:266
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayBeFinal(ASTNode caller, ASTNode child) {
		if (caller == getModifiersNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_mayBeFinal(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:267
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayBeTransient(ASTNode caller, ASTNode child) {
		if (caller == getModifiersNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_mayBeTransient(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/Modifiers.jrag:268
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayBeVolatile(ASTNode caller, ASTNode child) {
		if (caller == getModifiersNoTransform()) {
			return true;
		} else {
			return getParent().Define_boolean_mayBeVolatile(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/SyntacticClassification.jrag:78
	 * @apilevel internal
	 */
	public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
		if (caller == getTypeAccessNoTransform()) {
			return NameType.TYPE_NAME;
		} else {
			return getParent().Define_NameType_nameType(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/TypeAnalysis.jrag:260
	 * @apilevel internal
	 */
	public TypeDecl Define_TypeDecl_declType(ASTNode caller, ASTNode child) {
		if (caller == getInitOptNoTransform()) {
			return type();
		} else {
			return getParent().Define_TypeDecl_declType(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Frontend/TypeHierarchyCheck.jrag:141
	 * @apilevel internal
	 */
	public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
		if (caller == getInitOptNoTransform()) {
			return isStatic() || hostType().isInterfaceDecl();
		} else {
			return getParent().Define_boolean_inStaticContext(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/Annotations.jrag:80
	 * @apilevel internal
	 */
	public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
		if (caller == getModifiersNoTransform()) {
			return name.equals("FIELD");
		} else {
			return getParent().Define_boolean_mayUseAnnotationTarget(this, caller, name);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.5Frontend/GenericMethodsInference.jrag:35
	 * @apilevel internal
	 */
	public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
		if (caller == getInitOptNoTransform()) {
			return type();
		} else {
			return getParent().Define_TypeDecl_assignConvertedType(this, caller);
		}
	}

	/**
	 * @declaredat /Users/eric/Documents/workspaces/clara-soot/JastAddJ/Java1.4Backend/InnerClasses.jrag:67
	 * @apilevel internal
	 */
	public TypeDecl Define_TypeDecl_expectedType(ASTNode caller, ASTNode child) {
		if (caller == getInitOptNoTransform()) {
			return type().componentType();
		} else {
			return getParent().Define_TypeDecl_expectedType(this, caller);
		}
	}

	/**
	 * @apilevel internal
	 */
	public ASTNode rewriteTo() {
		return super.rewriteTo();
	}
}
