<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    extension-element-prefixes="redirect"
>
  <xsl:output method="text" indent="no"/>
  <xsl:strip-space elements="*"/>
  <xsl:template match="/singletons">
/* Soot - a J*va Optimization Framework
 * Copyright (C) 2003 Ondrej Lhotak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* THIS FILE IS AUTOMATICALLY GENERATED FROM soot/singletons.xml DO NOT EDIT! */

package soot;

/** A class to group together all the global variables in Soot. */
public class Singletons {
    public final class Global {
        private Global() {}
    }
    protected Global g = new Global();
<xsl:for-each select="/singletons/class">
    <xsl:variable name="class" select="."/>
    <xsl:variable name="undottedClass" select="translate(.,'.','_')"/>
    <xsl:variable name="instanceName">instance_<xsl:value-of select="$undottedClass"/></xsl:variable>
    private <xsl:value-of select="$class"/><xsl:text> </xsl:text><xsl:value-of select="$instanceName"/>;
    public <xsl:value-of select="$class"/><xsl:text> </xsl:text><xsl:value-of select="$undottedClass"/>() {
        if( <xsl:value-of select="$instanceName"/> == null ) {
	       	synchronized (this) {
		        if( <xsl:value-of select="$instanceName"/> == null )
	        		<xsl:value-of select="$instanceName"/> = new <xsl:value-of select="$class"/>( g );
	       	}
       	}
        return <xsl:value-of select="$instanceName"/>;
    }
    protected void release_<xsl:value-of select="$undottedClass"/>() {
    	<xsl:value-of select="$instanceName"/> = null;
    }
</xsl:for-each>
}
</xsl:template>
</xsl:stylesheet>