/* JSDefineFun.java

{{IS_NOTE
	Purpose:
		
	Description:
		
	History:
		Sep 25, 2012 2:22:01 PM , Created by jumperchen
}}IS_NOTE

Copyright (C) 2012 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
 */
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

/**
 * Pre-compiles ZK $define function to pure Javascript function
 * @author jumperchen
 * 
 */
public class JSDefineFun {

	private static final String START_BRACE = "{";

	private static final String END_BRACE = "}";

	private static final String START_BRACKET = "[";

	private static final String END_BRACKET = "]";

	private static final String COLON = ":";

	private static final String COMMA = ",";

	private static final String NULL = "null";

	private static final String FUNCTION = "function";
	
	private static final String DEFINE = "$define";
//	public static void main(String[] args) throws IOException {
//		String fileContent = FileUtils.readFileToString(new File("C:\\home\\jumperchen\\prj\\zk60\\zul\\src\\archive\\web\\js\\zul\\mesh\\Frozen.js"), "UTF-8");
//		String result = JSDefineFun.parseDefineArea(Comments.removeComment(fileContent));
//		FileUtils.writeStringToFile(new File("c:/t.js"), result);
//	}
	private static boolean smartContains(String source, String pattern) {
		if (source.trim().isEmpty()) return false;
		return smartIndexOf(source, pattern) >= 0;
	}
	private static int smartIndexOf(String source, String pattern) {
		if (source.trim().isEmpty()) return -1;
		return source.replaceAll("(\"([^\\\\\"]|\\\\.|\\\\)*\")|(\'([^\\\\\']|\\\\.|\\\\)*\')", "*").indexOf(pattern);
	}
	public static String parseDefineArea(String source) {
		final Scanner scanner = new Scanner(source);
		final StringBuilder origin = new StringBuilder(256);
		try {
			final StringBuilder defines = new StringBuilder(64);
			scanner.useDelimiter("\n");
			boolean startDef = false;
			int braceCnt = 0;
			while (scanner.hasNext()) {
				String line = scanner.next().trim();
				if (smartContains(line, DEFINE)) {
					startDef = true;

					if (smartContains(line, START_BRACE))
						braceCnt++;
					if (smartContains(line, END_BRACE))
						braceCnt--;
					continue;
				}
				
				if (!startDef) {
					origin.append(line).append("\n");
				} else {
					if (smartContains(line, START_BRACE))
						braceCnt++;
					if (smartContains(line, END_BRACE))
						braceCnt--;
					
					if (braceCnt == 0) {
						startDef = false;
						origin.append(replaceDefineFunction(defines.toString()));
						if (!line.endsWith(","))
							origin.deleteCharAt(origin.length() - 1); // remove the last comma
					} else if (!line.isEmpty()) {
						defines.append(line).append("\n");
					}
				}	
			}
		} finally {
			scanner.close();
		}
		return origin.toString();
	}

	public static String replaceDefineFunction(String defines) {
		final Scanner scanner = new Scanner(defines);
		List<Function> funs = new LinkedList<Function>();
		try {
			scanner.useDelimiter("\n");
			final StringBuilder funCnt = new StringBuilder(64);
			String funName = null;
			int braceCnt = 0;
			int bracket = 0;
			while (scanner.hasNext()) {
				String line = scanner.next().trim();
				if (funName == null) {
					int colon = line.indexOf(COLON);
					if (colon == -1)
						throw new IllegalArgumentException("Source: " + line);
					funName = line.substring(0, colon).trim();
					funCnt.append(line.substring(colon + 1).trim());
					if (funCnt.indexOf(NULL) >= 0) {
						funs.add(new Function(funName));
						funName = null;
						funCnt.setLength(0);
						continue;
					}
					if (smartContains(line, START_BRACKET))
						bracket++;
					if (smartContains(line, END_BRACKET))
						bracket--;
					if (smartContains(line, START_BRACE))
						braceCnt++;
					if (smartContains(line, END_BRACE))
						braceCnt--;
					if (braceCnt == 0 && bracket == 0) {
						if (line.endsWith(COMMA))
							funCnt.deleteCharAt(funCnt.length() - 1);
						funs.add(new Function(funName, funCnt.toString()));
						funName = null;
						funCnt.setLength(0);
					}
				} else {
					if (smartContains(line, START_BRACKET))
						bracket++;
					if (smartContains(line, END_BRACKET))
						bracket--;
					if (smartContains(line, START_BRACE))
						braceCnt++;
					if (smartContains(line, END_BRACE))
						braceCnt--;
					funCnt.append(line);
					if (bracket == 0 && braceCnt == 0) {
						if (funCnt.toString().endsWith("},")
								|| funCnt.toString().endsWith("],"))
							funCnt.deleteCharAt(funCnt.length() - 1);

						if (funCnt.toString().endsWith(END_BRACKET)) {
							funCnt.deleteCharAt(funCnt.indexOf(START_BRACKET));
							funCnt.deleteCharAt(funCnt.length() - 1);
							List<String> fs = parseFunction(funCnt.toString());
							if (fs.size() == 1) {
								funs.add(new Function(funName, fs.get(0), null));
								funName = null;
								funCnt.setLength(0);
							} else if (fs.size() == 2) {
								funs.add(new Function(funName, fs.get(0), fs.get(1)));
								funName = null;
								funCnt.setLength(0);
							} else {
								throw new IllegalArgumentException("The $define function might be wrong!"  + funCnt.toString());
							}
						} else {
							funs.add(new Function(funName, funCnt.toString()));
							funName = null;
							funCnt.setLength(0);
						}
					} else funCnt.append("\n");
				}
			}
			if (funName != null && funCnt.length() > 0) {
				funs.add(new Function(funName, funCnt.toString()));
				funName = null;
				funCnt.setLength(0);
			}
		} finally {
			scanner.close();
		}
		StringBuilder sb = new StringBuilder(128);
		for (Function f : funs)
			sb.append(f);
		return sb.toString();
	}

	private static List<String> parseFunction(String source) {
		Scanner scan = new Scanner(source);
		List<String> funs = new LinkedList<String>();
		StringBuilder sb = new StringBuilder(64);
		try {
			scan.useDelimiter("\n");
			int braceCnt = 0;
			while (scan.hasNext()) {
				String line = scan.next();
				int nullFun = line.indexOf(NULL), function = line
						.indexOf(FUNCTION);
				if (nullFun >= 0 && function >= 0) {
					String[] strs = line.split(COMMA);
					if (nullFun < function) {
						funs.add(null);
						sb.append(strs[1]).append("\n");
					} else {
						funs.add(strs[0]);
						funs.add(null);
						continue; // function and null at the same line
					}
				}
				
				int funIndex;
				if ((funIndex = smartIndexOf(line, FUNCTION)) >= 0) {
					int end = smartIndexOf(line, END_BRACE);
					
					if (end >= 0) {
						braceCnt--;
						if (funIndex > end) {
							int ci = line.indexOf(COMMA);
							sb.append(line.substring(0, ci));
							funs.add(sb.toString());
							sb.setLength(0);
							sb.append(line.substring(ci + 1));
						}
					} else if (nullFun == -1)
						sb.append(line).append("\n");

					if (smartContains(line, START_BRACE))
						braceCnt++;
					
				} else {
					if (smartContains(line, START_BRACE))
						braceCnt++;
					if (smartContains(line, END_BRACE))
						braceCnt--;
					if (braceCnt == 0) {
						if (line.endsWith(COMMA)) {
							line = line.substring(0, line.length() - 1);
						} else if (smartContains(line, NULL)) {
							int comma = line.indexOf(COMMA);
							if (comma >= 0) {
								String[] results = line.split(COMMA);
								sb.append(results[0]);
								funs.add(sb.toString());
								funs.add(null);
								break; // end the loop
							} else {
								if (funs.isEmpty() && sb.toString().trim().endsWith(COMMA)) {
									String s = sb.toString().trim();
									funs.add(s.substring(0, s.length() - 1));
									funs.add(null);
									break; // end the loop
								}
								throw new IllegalArgumentException("Source: "
										+ line);
							}
						}
						sb.append(line);
						funs.add(sb.toString());
						sb.setLength(0);
					} else sb.append(line).append("\n");
				}
			}
		} finally {
			scan.close();
		}
		return funs;
	}

	private static class Function {
		private static String defSet11 = "set%3$s: (function (nm, before, after) {return function (v, opts) {var o = this[nm];this.__fname__ = nm.substring(1);this[nm] = v = before.apply(this, arguments);if (o !== v || (opts && opts.force))after.apply(this, arguments);this.__fname__=null;return this;};})('%2$s', (%4$s), (%5$s))";

		private static String defSet10 = "set%3$s: (function (nm, before) {return function (/*v, opts*/) {this.__fname__ = nm.substring(1);this[nm] = before.apply(this, arguments);this.__fname__=null;return this;};})('%2$s', (%4$s))";

		private static String defSet01 = "set%3$s: (function (nm, after) {return function (v, opts) {var o = this[nm];this[nm] = v;if (o !== v || (opts && opts.force)){this.__fname__ = nm.substring(1);after.apply(this, arguments);this.__fname__=null;}return this;};})('%2$s', (%5$s))";

		private static String defSet00 = "set%3$s: (function (nm) {return function (v) {this[nm] = v;return this;};})('%2$s')";

		private static String defGet = "get%3$s: _zkf$ = function() {return this._%1$s;}, is%3$s: _zkf$";

		private String _name;

		private String _after;

		private String _before;

		Function(String name) {
			_name = name;
		}

		Function(String name, String after) {
			_name = name;
			_after = after;
		}

		Function(String name, String before, String after) {
			_name = name;
			_before = before;
			_after = after;
		}
 
		public String toString() {
			if (_name == null)
				throw new IllegalArgumentException("Function name cannot be null!\n"
						+ (_before != null ? _before : "")
						+ (_after != null ? _after : ""));
			// the logical is the same as zk.js
			StringBuilder sb = new StringBuilder(128);
			final String s1 = _name;
			final String s2 = "_" + _name;
			final String s3 = String.valueOf(_name.charAt(0)).toUpperCase() + (_name.substring(1));
			sb.append(String.format(_before != null ? _after != null ? defSet11
					: defSet10 : _after != null ? defSet01 : defSet00, s1, s2,
					s3, _before, _after));
			sb.append(",").append(String.format(defGet, s1, s2, s3)).append(",");
			return sb.toString();
		}
	}
}
