import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;

/**
 * 
 */

/**
 * @author jumperchen
 * 
 */
public class ZipJS {
	private static void log(Object... os) {
		for (Object o : os) {
			System.out.print(o + (os[os.length - 1] != o ? "," : ""));
		}
		System.out.println();
	}

	private static List<File> getFiles(File dir, List<File> list) {
		String dirName = dir.getName();
		if (".svn".equals(dirName) || ".git".equals(dirName) || "CVS".equals(dirName))
			return list;
		if (dir.isDirectory() && !dirName.contains("less")) { //Skip less files
			for (File f : dir.listFiles()) {
				getFiles(f, list);
			}
		} else if (dir.isFile())
			list.add(dir);
		return list;
	}

	/**
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {
		if (args.length < 2) {
			log("\n");
			log("Usage:\n");
			log("	ZipJS srcdir dstdir");
			log("All files are copied from one directory to another.");
			log("The JavaScript files are compressed during copying.");
			log("\n");
			System.exit(-1);
		}
		if (!args[1].endsWith("_na_dir_")) {

			final File srcdir = new File(args[0]);
			final File dstdir = new File(args[1]);
			final String root = srcdir.getPath();
			if (!dstdir.isDirectory())
				dstdir.mkdir();

			final ErrorReporter4ZK errorReport = new ZipJS.ErrorReporter4ZK(args.length > 2 ? Boolean.valueOf(args[2]) : false);
			for (File srcFile : getFiles(srcdir, new ArrayList<File>(30))) {
				final String fileName = srcFile.getPath().replace(root, "");
				File copyToFile = new File(dstdir, fileName);

				if (copyToFile.exists()
						&& (copyToFile.lastModified() > srcFile.lastModified())) {
					continue;
				}

				if (!copyToFile.getParentFile().isDirectory()) {
					copyToFile.getParentFile().mkdirs();
				}

				if (fileName.endsWith(".js") || fileName.endsWith(".css.dsp")
						|| fileName.endsWith(".css")) {

					log("Compress... " + srcFile);
					if (fileName.endsWith(".js")) {
						String fileContent = FileUtils.readFileToString(
								srcFile, "UTF-8");

						try {
							fileContent = Comments.removeComment(fileContent);
						} catch (IllegalStateException ex) {
							log("clear comment failed:" + copyToFile.getName()
									+ ":" + ex.getMessage()
									+ ":skip clear comment step");
						}
						//log("FileName: " + fileName);
						String outFileName = fileName.endsWith(".js") ?
								fileName.substring(0, fileName.length() - 3) + ".src.js" : fileName;
						File outSrcFile = new File(dstdir, outFileName);

						//log("outSrcFile: " + outSrcFile);
						FileUtils.writeStringToFile(outSrcFile, fileContent,
								"UTF-8");

						InputStreamReader in = null;
						OutputStreamWriter out = null;
						boolean error = false;
						try {
							if (args.length == 3 && Boolean.parseBoolean(args[2])) {
								log("Replace $define function...");
								in = new UnicodeReader(
										new ByteArrayInputStream(JSDefineFun
												.parseDefineArea(fileContent)
												.getBytes("UTF-8")), "UTF-8");
							} else {
								// bug fix for UTF8 BOM issue by TonyQ
								in = new UnicodeReader(new FileInputStream(
										srcFile), "UTF-8");
							}

							out = new OutputStreamWriter(new FileOutputStream(
									copyToFile), "UTF-8");
							errorReport.setDefaultFileName(srcFile.getName());
							JavaScriptCompressor compressor = new JavaScriptCompressor(
									in, errorReport);
							compressor.compress(out, -1, true, false, false,
									false);
							// zk modified here
						} catch (EvaluatorException e) {
							error = true;
						} finally {
							if (in != null) {
								in.close();
							}
							if (out != null) {
								out.close();
							}
						}
						
						if (error) {
							FileUtils.forceDelete(copyToFile);
							System.exit(-1);
						}
					} else {
						InputStreamReader in = null;
						OutputStreamWriter out = null;
						try {
							// bug fix for UTF8 BOM issue by TonyQ
							in = new UnicodeReader(
									new FileInputStream(srcFile), "UTF-8");

							out = new OutputStreamWriter(new FileOutputStream(
									copyToFile), "UTF-8");

							CssCompressor compressor = new CssCompressor(in);
							compressor.compress(out, -1);

							// zk modified here
						} finally {
							if (in != null) {
								in.close();
							}
							if (out != null) {
								out.close();
							}
						}
					}
				} else {
					log("Copy... " + srcFile);
					FileUtils.copyFile(srcFile, copyToFile);
				}
				if (copyToFile != null)
					copyToFile.setLastModified(copyToFile.lastModified() + 500);
			}
		}
	}
	static class ErrorReporter4ZK implements ErrorReporter {

	    private String defaultFilename_;
	    private boolean acceptWarn_;
	    private int warningCnt_;
	    private int errorCnt_;

	    public ErrorReporter4ZK(boolean jswarn) {
	        acceptWarn_ = jswarn;
	    }

	    public void setDefaultFileName(String v) {
	        if (v.length() == 0) {
	            v = null;
	        }
	        defaultFilename_ = v;
	    }

	    public int getErrorCnt() {
	        return errorCnt_;
	    }

	    public int getWarningCnt() {
	        return warningCnt_;
	    }

	    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
	        String fullMessage = newMessage(message, sourceName, line, lineSource, lineOffset);
	        log(fullMessage);
	        errorCnt_++;
	    }

	    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
	        error(message, sourceName, line, lineSource, lineOffset);
	        throw new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
	    }

	    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
	        if (acceptWarn_) {
	            String fullMessage = newMessage(message, sourceName, line, lineSource, lineOffset);
	            log(fullMessage);
	            warningCnt_++;
	        }
	    }

	    private String newMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
	        StringBuilder back = new StringBuilder();
	        if ((sourceName == null) || (sourceName.length() == 0)) {
	            sourceName = defaultFilename_;
	        }
	        if (sourceName != null) {
	            back.append(sourceName)
	                .append(": line ")
	                .append(line)
	                .append(": column ")
	                .append(lineOffset)
	                .append(": ")
	                ;
	        }
	        if ((message != null) && (message.length() != 0)) {
	            back.append(message);
	        } else {
	            back.append("unknown error");
	        }
	        if ((lineSource != null) && (lineSource.length() != 0)) {
	            back.append("\n\t")
	                .append(lineSource)
	                ;
	        }
	        return back.toString();
	    }

	}
}
