package demo.poll;

import com.psddev.dari.db.Query;
import com.psddev.dari.db.Record;

public class User extends Record {

    @Indexed private String userName;
    private String firstName;
    private String lastName;

    public String getUserName() {
        return userName;
    }
    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getFirstName() {
        return firstName;
    }
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public static User getOrCreateUser(String userName) {

        User user = Query.from(User.class)
                .where("userName = ?", userName)
                .first();

        if (user == null) {
            if (userName == null || "".equals(userName = userName.trim())) {
                return null;
            } else {
                user = new User();
                user.setUserName(userName);
                user.save();
                return user;
            }
        } else {
            return user;
        }
    }
}