// MD5 plugin. 
// Be sure to add the RSA license notice somewhere in your installer.
// 
// Matthew "IGx89" Lieder
//  Author
//
// KJD
//  -modified to reduce size and use exdll.h
//   (reduced to about 6KB uncompressed, by removing CRTL dependency)
//
// Davy Durham
//  -MD5.cpp fix (correct for loop used to replace memset, exceeded bounds)
//
// Shengalts Aleksander aka Instructor
//  -New command: "GetMD5Random"
//  -Changed names: "GetFileMD5" -> "GetMD5File", "GetMD5" -> "GetMD5String"
//  -Fixed: string lenght error
//
// KJD
//  -added dual exports for compatibility with prior versions



#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "MD5.h"
#include "ExDLL.h"


void *operator new( unsigned int num_bytes )
{
  return GlobalAlloc(GPTR,num_bytes);
}
void operator delete( void *p ) { if (p) GlobalFree(p); }


#ifdef ENABLE_GETMD5FILE
extern "C" void __declspec( dllexport ) GetMD5File(HWND hwndParent, int string_size, 
								   char *variables, stack_t **stacktop)
{
	EXDLL_INIT();

	// generate MD5sum of file
	{
		char tmp[1024];
		char *buf=NULL;

		popstring(tmp);
		buf = MD5File(tmp);
		pushstring(buf);
		delete buf;
	}
}
#endif // ENABLE_GETMD5FILE

#ifdef ENABLE_GETMD5STRING
extern "C" void __declspec( dllexport ) GetMD5String(HWND hwndParent, int string_size, 
								char *variables, stack_t **stacktop)
{
	EXDLL_INIT();

	// generate MD5sum of string
	{
		char tmp[1024];
		char *buf=NULL;

		popstring(tmp);
		buf = MD5String(tmp);
		pushstring(buf);
		delete buf;
	}
}
#endif // ENABLE_GETMD5STRING

#ifdef ENABLE_GETMD5RANDOM
extern "C" void __declspec( dllexport ) GetMD5Random(HWND hwndParent, int string_size, 
								char *variables, stack_t **stacktop)
{
	EXDLL_INIT();

	// generate random MD5sum
	{
		DWORD dwTickCount=0;
		char lTickCount[1024];
		char *buf=NULL;

		Sleep(1);
		dwTickCount=GetTickCount();
		wsprintf(lTickCount,"%d",dwTickCount);
		buf = MD5String(lTickCount);
		pushstring(buf);
		delete buf;
	}
}
#endif // ENABLE_GETMD5RANDOM

extern "C" BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}
