package soot.dex.exampleApp;

import java.io.InputStream;
import java.util.List;

import android.app.Activity;
import android.os.Bundle;

public class ExampleAppActivity extends Activity {
    /** Called when the activity is first created. */
	public ExampleAppActivity() {
		super();
	}
	
	public int[] x;
	public int aint;
	public int bint;
	public int cint;
	public long along;
	public long blong;
	public long clong;
	public float afloat;
	public float bfloat;
	public float cfloat;
	public double adouble;
	public double bdouble;
	public double cdouble;
	public Object testObj1;
	public Object testObj2;
	
	public static int staticInt = 0;
	public static long staticLong = 342;
	public static byte staticbyte = 0x1;
	public static char staticchar = 'c';
	public static short staticshort = 2;
	public static boolean staticBool = true;
	public static Object staticObj = new Object();
	public static double staticDouble = 12345;
	public static float staticFloat = 12345f;
	
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        System.out.println("Starting tests...");
        objectAssign objectAssign = new objectAssign();

        System.out.println("new Object Assign Test: "+objectAssign);
        
        List<Integer> l;
        l = null;
        
        boolean b = (l == null)? true : false;
        System.out.println(b);
        
        
        System.out.println("Null tests ended");
        test1 testObj = new test1();
    	testObj.field3 = new test1();
    
    	testObj.field3.interfaceMethod();
    	System.out.println("Interface Method called");
    	
    	testObj.field2 = staticObj;
    	test1.StaticFun();
    	System.out.println("Static Function called");
    	
    	final Object SOME_CONSTANT_OBJECT = Consts.class.getClass();
    	System.out.println("const-class called: "+ SOME_CONSTANT_OBJECT);
    	
    	String stringData = "sadasda";
    	System.out.println("string assigned: "+stringData);
    	
    	fillArrayData();
    	moveResultWide();
    	WideReturn();
    	aPutGet();
    	iPutGet();
    	sPutGet();
    	IfTest();
    	IfTestZero();
    	instanceOf();
    	cmpKind();
    	//moveException(null);
    	
    	try {
			throwException();
		} catch (Exception e) {
			e.printStackTrace();
		}
    	
    	binOP2addr();
    	binOpUnop();
    	filledNewArray();
    	filledNewArrayRange();
    	invokeRange();    	
    	
        setContentView(R.layout.main);
        System.out.println("End of tests.");
    }
    
    public void fillArrayData() {
    	final float[] yFloat = {3.14f, 11.13f, 44, 5 }; //width: 4
    	final char[] yChar = {'a', 'b', 'c', 'd', 'e'}; //width: 2
    	final short[] yShort = {1, 2, 3, 4, 5}; //width: 2
    	final int[] yInt = {1, 2, 3, 4, 5}; //width: 4
    	final double[] yDouble = {12, 12, 3432, 223, 324}; //width: 8
    	final boolean[] yBoolean = {true, true, false, false, true}; //none
    	final long[] yLong = {1l,2l, 3l, 4l, 5l}; //width: 8
    	final byte[] yByte = {0x1, 0x2, 0x3, 0x4, 0x5}; //width: 1
    	System.out.println("fill-array-data instructions called:");
    	System.out.println(yFloat);
    	System.out.println(yChar);
    	System.out.println(yShort);
    	System.out.println(yInt);
    	System.out.println(yDouble);
    	System.out.println(yBoolean);
    	System.out.println(yLong);
    	System.out.println(yByte);
    }
    public void moveResultWide() {
    	System.out.println("move-result-wide instruction called:");
    	long longErg = WideReturn();
    	System.out.println(longErg);
    }
    
    public long WideReturn() {
    	long longVar = 123l;
    	System.out.println("return-wide instruction called");
    	return longVar;
    	
    }

	
    public void aPutGet() {
    	int[] intArr = new int[1];
    	long[] longArr = new long[1];
    	byte[] byteArr = new byte[1];
    	char[] charArr = new char[1];
    	short[] shortArr = new short[1];
    	boolean[] boolArr = new boolean[1];
    	Object[] objArr = new Object[1];
    	
    	intArr[0] = 1;
    	longArr[0] = 4l;
    	byteArr[0] = 0x1;
    	charArr[0] = 'c';
    	shortArr[0] = 1;
    	boolArr[0] = true;
    	objArr[0] = new Object();
    	
    	System.out.println(intArr[0]);
    	System.out.println(longArr[0]);
    	System.out.println(byteArr[0]);
    	System.out.println(charArr[0]);
    	System.out.println(shortArr[0]);
    	System.out.println(boolArr[0]);
    	System.out.println(objArr[0]);
    	
    	System.out.println(charArr.length);
    	
    	System.out.println("aPut and aGet and array.length ops called");
    }
    public void iPutGet() {
    	test1 testObj = new test1();
    	testObj.IntVar = 1;
    	testObj.LongVar = 4l;
    	testObj.byteVar = 0x3;
    	testObj.charVar = 'c';
    	testObj.shortVar = 2;
    	testObj.BoolVar = true;
    	testObj.ObjVar = new Object();
    	

    	System.out.println(testObj.IntVar);
    	System.out.println(testObj.LongVar);
    	System.out.println(testObj.byteVar);
    	System.out.println(testObj.charVar);
    	System.out.println(testObj.shortVar);
    	System.out.println(testObj.BoolVar);
    	System.out.println(testObj.ObjVar);
    	
    	System.out.println("iPut and iGet ops called");
    }
    public void sPutGet() {
    	staticInt = 2;
    	staticLong = 34112;
    	staticbyte = 0x2;
    	staticchar = 'h';
    	staticshort = 4;
    	staticBool = false;
    	//staticObj = null;
    	

    	System.out.println(staticInt);
    	System.out.println(staticLong);
    	System.out.println(staticbyte);
    	System.out.println(staticchar);
    	System.out.println(staticshort);
    	System.out.println(staticBool);
    	//System.out.println(staticObj);
    	
    	System.out.println("sPut and sGet ops called");
    }
    public void IfTest() {
    	int two1 = 2;
    	int two = 2;
    	int minus2 = -2;
    	if(two == minus2) {
    		System.out.println(1);
    	}
    	else if(two != two1) {
    		System.out.println(1);
    	}
    	else if(two < minus2) {
    		System.out.println(1);
    	}
    	else if(minus2 >= two) { 
    		System.out.println(1);
    	}
    	else if(minus2 > two) {
    		System.out.println(1);
    	}
    	else if(two <= minus2) {
    		System.out.println(1);
    	}
    	else {
    		System.out.println(1);
    	}
    	System.out.println("IF ops called");
    }
    public void IfTestZero() {
    	int zero = 0;
    	int two = 2;
    	int minus2 = -2;
    	if(two == 0) {
    		System.out.println(1);
    	}
    	else if(zero != 0) {
    		System.out.println(1);
    	}
    	else if(two < 0) {
    		System.out.println(1);
    	}
    	else if(minus2 >= 0) { 
    		System.out.println(1);
    	}
    	else if(minus2 > 0) {
    		System.out.println(1);
    	}
    	else if(two <= 0) {
    		System.out.println(1);
    	}
    	else {
    		System.out.println(1);
    	}
    	System.out.println("IFz ops called");
    }
    public Object instanceOf() {
    	System.out.println("instance op called");
    	return (testObj1 instanceof Object);
    }
    public int cmpKind() {
    	if(staticLong==123456l){
    		System.out.println(1);
    	} 
    	if (staticFloat>1254.123f){
    		System.out.println(1);
    	}
    	if (staticFloat<1254.123f){
    		System.out.println(1);
    	}
    	if (staticDouble<165343267894.123){
    		System.out.println(1);
    	}
    	if (staticDouble>16532267894.123){
    		System.out.println(1);
    	}
    	System.out.println("CMP ops called");
    	return 0;
    }
    public int moveException( InputStream is ) {
        int c = 0;
        try {
            c = is.read();
        } catch( Exception ex ) {
            c = -1;
        }
        System.out.println("Move Exception op called");
        return c;
    }
    public void throwException() throws Exception{
    	System.out.println("Throw Exception op called");
    	throw new Exception();
    }
    
    public void binOP2addr() {
    	aint = 1;
    	bint = 1;
    	cint = aint+bint;
    	cint = aint-bint;
    	cint = aint*bint;
    	cint = aint/bint;
    	cint = aint%bint;
    	cint = aint&bint;
    	cint = aint|bint;
    	cint = aint^bint;
    	cint = aint<<bint;
    	cint = aint>>bint;
    	cint = aint>>>bint;
    	
    	along = 1;
    	blong = 1;
    	clong = along+blong;
    	clong = along-blong;
    	clong = along*blong;
    	clong = along/blong;
    	clong = along%blong;
    	clong = along&blong;
    	clong = along|blong;
    	clong = along^blong;
    	clong = along<<blong;
    	clong = along>>blong;
    	clong = along>>>blong;
    	
    	afloat = 1f;
    	bfloat = 1f;
    	cfloat = afloat+bfloat;
    	cfloat = afloat-bfloat;
    	cfloat = afloat*bfloat;
    	cfloat = afloat/bfloat;
    	cfloat = afloat%bfloat;
    	
    	adouble = 1f;
    	bdouble = 1f;
    	cdouble = adouble+bdouble;
    	cdouble = adouble-bdouble;
    	cdouble = adouble*bdouble;
    	cdouble = adouble/bdouble;
    	cdouble = adouble%bdouble;
    	
    	System.out.println("Arithmetic /2addr ops called");
    }
    public void binOpUnop() {
    	int aInt = -5;
    	int bInt = 5;
    	int ergInt = 0;
    	long aLong = 1;
    	long bLong = -1;
    	long ergLong = 0;
    	double aDouble = 1;
    	double bDouble = -1;
    	double ergDouble = 0;
    	float aFloat = 1.0f;
    	float bFloat = 1.0f;
    	float ergFloat = 0;
    	
    	//sum
    	ergInt = aInt + bInt;
    	ergLong = aLong + bLong;
    	ergDouble = aDouble+bDouble;
    	ergFloat = aFloat+bFloat;
    	
    	//sub
    	ergInt = aInt - bInt;
    	ergLong = aLong - bLong;
    	ergDouble = aDouble-bDouble;
    	ergFloat = aFloat-bFloat;
    	
    	//mul
    	ergInt = aInt * bInt;
    	ergLong = aLong * bLong;
    	ergDouble = aDouble*bDouble;
    	ergFloat = aFloat*bFloat;   
    	
    	//div
    	ergInt = aInt / bInt;
    	ergLong = aLong / bLong;
    	ergDouble = aDouble/bDouble;
    	ergFloat = aFloat/bFloat;   
    	 	
    	//rem
    	ergInt = aInt % bInt;
    	ergLong = aLong % bLong;
    	ergDouble = aDouble%bDouble;
    	ergFloat = aFloat%bFloat;   
    	
    	//and
    	ergInt = aInt & bInt;
    	ergLong = aLong & bLong;
    	
    	//or
    	ergInt = aInt | bInt;
    	ergLong = aLong | bLong; 
    	
    	//xor
    	ergInt = aInt ^ bInt;
    	ergLong = aLong ^ bLong;
    	
    	//shl
    	ergInt = aInt << bInt;
    	ergLong = aLong << bLong; 
    	
    	//shr
    	ergInt = aInt >> bInt;
    	ergLong = aLong >> bLong;  
    	
    	//ushr
    	ergInt = aInt >>> bInt;
    	ergLong = aLong >>> bLong;
    	
    	System.out.println("Binary Ops called");
    	
   	 
	   	 ergInt = -ergInt;
	   	 
	   	 ergInt = ~ergInt;	
	   	 
	   	System.out.println(ergInt);
	   	
	   	 ergLong = -ergLong;
	   	 ergLong = ~ergLong;
	   	 
	   	 ergFloat = -ergFloat;
	   	 ergDouble = -ergDouble;
	   	 System.out.println("Unary ops called");
   	 
    	short shortVal = (short) ergInt;
    	char charVal = (char) ergInt;
    	byte byteVal = (byte) ergInt;
    	
    	 ergInt = (int) ergDouble;
    	 ergLong = (long) ergDouble;
    	 ergFloat = (float) ergDouble;
    	 
    	 ergInt = (int) ergFloat;
    	 ergLong = (long) ergFloat;
    	 ergDouble = (double) ergFloat;
    	 
    	 ergInt = (int) ergLong;
    	 ergDouble = (double) ergLong;
    	 ergFloat = (float) ergLong;
    	 
    	 ergLong = (long) ergInt;
    	 ergDouble = (double) ergInt;
    	 ergFloat = (float) ergInt;
    	 
    	 System.out.println("Unary casts called");
    	 System.out.println(shortVal);
    	 System.out.println(charVal);
    	 System.out.println(byteVal);
    	 
    	 //binOp lit8
    	 ergInt = ergInt + 0xf;
    	 ergInt =  0x2 - ergInt;
    	 ergInt = ergInt * 0xf;
    	 ergInt = ergInt / 0xf;
    	 ergInt = ergInt % 0xf;
    	 ergInt = ergInt & 0xf;
    	 ergInt = ergInt | 0xf;
    	 ergInt = ergInt ^ 0xf;
    	 ergInt = ergInt << 0xf;
    	 ergInt = ergInt >> 0x2;
    	 ergInt = ergInt >>> ~0xf;
    	 System.out.println("Binary Ops Lit8 called");
    	//binOp lit16
    	 ergInt = ergInt + 0xff;
    	 ergInt = 0xfd - ergInt;
    	 ergInt = ergInt * 0xff;
    	 ergInt = ergInt / 0xff;
    	 ergInt = ergInt % 0xff;
    	 ergInt = ergInt & 0xff;
    	 ergInt = ergInt | 0xff;
    	 ergInt = ergInt ^ 0xff;
    	 System.out.println("Binary Ops Lit16 called");

    }
    


    public static Object filledNewArray() {
    	System.out.println("filled-new-array called");
        Object[][] x = new Object[2][5];
        return x;
    }

    public static Object[][][][][][] filledNewArrayRange() {
    	System.out.println("filled-new-array/range called");
        return new Object[5][4][3][2][1][8];
    }
    
    private static void staticMethodThatNeedsInvokeRange(int a, int b, int c, int d, int e, int f) {
    	System.out.println("Static Invoke Range, Param a:"+ a);
    }
    
    private void methodThatNeedsInvokeRange(int a, int b, int c, int d, int e, int f) {
    	System.out.println("Invoke Range, Param a:"+ a);
    }
    
    public void invokeRange() {
        int src = 6;
        int dest = 7;

        staticMethodThatNeedsInvokeRange(src, 0, dest, 1, 5, 0);
        methodThatNeedsInvokeRange(dest, 0, src, 1, 5, 0);
    }

    
    
}