import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import com.asual.lesscss.LessException;
import com.yahoo.platform.yui.compressor.CssCompressor;

public class CpLess {

	private final static ZkLessEngine engine = new ZkLessEngine();

	public static void main(String[] args) throws IOException {
		if (args.length < 2) {
			log("\n");
			log("Usage:\n");
			log("	CpLess srcdir dstdir themeName");
			log("All less files are compiled into dsp files from srcdir to dstdir.");
			log("\n");
			System.exit(-1);
		}
		if (!args[1].endsWith("_na_dir_")) {
			final File srcdir = new File(args[0]);
			final File dstdir = new File(args[1]);
			final String theme = args.length == 3 ? args[2] : "";

			if (!dstdir.isDirectory())
				dstdir.mkdir();

			// compile from jar files
			if (args[0].endsWith("jar")) {
				final Enumeration<JarEntry> entries = new JarFile(args[0])
						.entries();
				while (entries.hasMoreElements()) {
					final JarEntry entry = entries.nextElement();
					final String name = entry.getName();
					if (!entry.isDirectory() && name.endsWith(".less")
							&& !name.contains("_")) {
						// prepare input
						InputStream input = CpLess.class
								.getResourceAsStream("/" + name);
						// prepare output
						// replace folder name
						String path = name.replace("/less", "/css");
						// replace theme folder name
						if (!"".equals(theme))
							path = path.replace("web", "/web/" + theme);
						// replace file sub-name for compressed file
						path = path.replace(".less", ".css.dsp");
						File output = new File(dstdir, path);
						if (!output.getParentFile().isDirectory()) {
							output.getParentFile().mkdirs();
						}
						log("Compiling... " + name);
						try {
							engine.compile(input, output, theme,
									"/web/__faker__", true);
						} catch (LessException e) {
							log(e.getMessage());
						}
					}
				}
			} else {
				final String root = srcdir.getPath();
				for (File srcFile : getFiles(srcdir, new ArrayList<File>(30))) {
					if (srcFile.getName().startsWith("_"))
						continue; // skip files that will be imported by others

					final String sep = File.separator;
					String fileName = srcFile.getPath().replace(root, "");
					// replace folder name
					String path = fileName.replace(sep + "less", sep + "css");
					// replace theme folder name
					if (!"".equals(theme)) {
						path = path.replace(sep + "web", sep + "web" + sep
								+ theme);
					}
					// replace file sub-name for source file
					String dspSrcPath = path.replace(".less", ".css.dsp.src");
					// replace file sub-name for compressed file
					String dspPath = path.replace(".less", ".css.dsp");
					File dspSrcFile = new File(dstdir, dspSrcPath);
					File dspFile = new File(dstdir, dspPath);

					if (!dspSrcFile.getParentFile().isDirectory()) {
						dspSrcFile.getParentFile().mkdirs();
					}

					if (fileName.endsWith(".less")) {
						/* Compile less */
						log("Compiling... " + srcFile);
						String result = null;
						try {
							result = engine.compile(srcFile, theme, root
									+ "/__faker__");
						} catch (LessException e) {
							log(e.getMessage());
						}
						/* if compile succeed */
						if (result != null) {
							result = SyntaxHelper.decodeDsp(result);
							/* Output to *.css.dsp.src file */
							if (!dspSrcFile.exists())
								dspSrcFile.createNewFile();
							if (!dspFile.exists())
								dspFile.createNewFile();
							BufferedWriter bw = new BufferedWriter(
									new FileWriter(dspSrcFile));
							bw.write(result);
							bw.close();
						}
					}
					/* Compress *.css.dsp.src to *.css.dsp */
					// bug fix for UTF8 BOM issue by TonyQ
					InputStreamReader in = new UnicodeReader(
							new FileInputStream(dspSrcFile), "UTF-8");
					OutputStreamWriter out = new OutputStreamWriter(
							new FileOutputStream(dspFile), "UTF-8");
					CssCompressor compressor = new CssCompressor(in);
					compressor.compress(out, -1);
					in.close();
					out.close();
				}
			}
		}
	}

	private static void log(Object... os) {
		for (Object o : os) {
			System.out.print(o + (os[os.length - 1] != o ? "," : ""));
		}
		System.out.println();
	}

	private static List<File> getFiles(File dir, List<File> list) {
		String dirName = dir.getName();
		if (".svn".equals(dirName) || ".git".equals(dirName)
				|| "CVS".equals(dirName))
			return list;
		if (dir.isDirectory()) {
			for (File f : dir.listFiles()) {
				getFiles(f, list);
			}
		} else if (dir.isFile() && dirName.endsWith(".less"))
			list.add(dir);
		return list;
	}
}
