import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import com.asual.lesscss.loader.ChainedResourceLoader;
import com.asual.lesscss.loader.ClasspathResourceLoader;
import com.asual.lesscss.loader.FilesystemResourceLoader;
import com.asual.lesscss.loader.HTTPResourceLoader;
import com.asual.lesscss.loader.ResourceLoader;
import com.yahoo.platform.yui.compressor.CssCompressor;

public class ZkLessEngine {

	private final LessEngine compiler = new LessEngine(new LessOptions(),
			defaultResourceLoader());

	private ResourceLoader defaultResourceLoader() {
		ResourceLoader resourceLoader = new ChainedResourceLoader(
				new FilesystemResourceLoader(), new ClasspathResourceLoader(
						ZkLessEngine.class.getClassLoader()),
				new HTTPResourceLoader());
		resourceLoader = new ZKResourceLoader(resourceLoader);
		return resourceLoader;
	}

	public void compile(Object input, File output, String themeName)
			throws LessException, IOException {
		compile(input, output, themeName, null, false);
	}

	public void compile(Object input, File output, String themeName,
			String location) throws LessException, IOException {
		compile(input, output, themeName, location, false);
	}

	public void compile(Object input, File output, String themeName,
			String location, boolean compress) throws LessException,
			IOException {
		String source = SyntaxHelper.encodeDsp(loadSource(input), themeName);
		/* Compile less */
		String result = null;
		result = compiler.compile(source, location);
		/* if compile succeed */
		if (result != null) {
			result = SyntaxHelper.decodeDsp(result);
			/* Create output file */
			if (!output.exists())
				output.createNewFile();

			if (compress) {
				// bug fix for UTF8 BOM issue by TonyQ
				InputStreamReader in = new UnicodeReader(
						new ByteArrayInputStream(result.getBytes()), "UTF-8");
				OutputStreamWriter out = new OutputStreamWriter(
						new FileOutputStream(output), "UTF-8");
				CssCompressor compressor = new CssCompressor(in);
				compressor.compress(out, -1);
				in.close();
				out.close();
			} else {
				BufferedWriter bw = new BufferedWriter(new FileWriter(output));
				bw.write(result);
				bw.close();
			}
		}
	}

	public String compile(Object input, String themeName, String location)
			throws LessException {
		String source = SyntaxHelper.encodeDsp(loadSource(input), themeName);
		String result = null;
		result = compiler.compile(source, location);
		return SyntaxHelper.decodeDsp(result);
	}

	public void compile(File input, File output) throws LessException,
			IOException {
		compile(input, output, false);
	}

	public void compile(File input, File output, boolean compress)
			throws LessException, IOException {
		if (!input.exists())
			log("Input File Not exists");

		// encode DSP Theme function
		String source = loadSource(input);
		source = SyntaxHelper.encodeDsp(source, "");

		// Compile less to css
		String root = input.getPath().replace(input.getName(), "");
		String compiled = compiler.compile(source, root);

		// decode DSP Theme function
		String uncompressed = SyntaxHelper.decodeDsp(compiled);

		if (!output.exists())
			output.createNewFile();
		if (compress) {
			InputStreamReader in = new InputStreamReader(
					new ByteArrayInputStream(uncompressed.getBytes()));
			OutputStreamWriter out = new OutputStreamWriter(
					new FileOutputStream(output), "UTF-8");
			CssCompressor compressor = new CssCompressor(in);
			compressor.compress(out, -1);
			in.close();
			out.close();
		} else {
			BufferedWriter bw = new BufferedWriter(new FileWriter(output));
			bw.write(uncompressed);
			bw.close();
		}
	}

	private String loadSource(Object src) {
		Reader reader = null;
		if (src instanceof File)
			try {
				reader = new FileReader((File) src);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		else if (src instanceof InputStream)
			reader = new InputStreamReader((InputStream) src);
		else
			log("Unknow input source");
		reader = new BufferedReader(reader);
		StringWriter w = new StringWriter();
		char[] buf = new char[1024];
		int numRead = 0;
		try {
			while ((numRead = reader.read(buf)) != -1) {
				String readData = String.valueOf(buf, 0, numRead);
				w.append(readData);
				buf = new char[1024];
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return w.toString();
	}

	private static void log(Object... os) {
		for (Object o : os) {
			System.out.print(o + (os[os.length - 1] != o ? "," : ""));
		}
		System.out.println();
	}
}
